/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AddressDto;
import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.BlockFeeMultiplierDto;
import io.nem.symbol.catapult.builders.BlockHeaderBuilder;
import io.nem.symbol.catapult.builders.BlockTypeDto;
import io.nem.symbol.catapult.builders.DifficultyDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Hash256Dto;
import io.nem.symbol.catapult.builders.HeightDto;
import io.nem.symbol.catapult.builders.ImportanceBlockFooterBuilder;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.VrfProofBuilder;
import java.io.DataInputStream;

public class ImportanceBlockHeaderBuilder
extends BlockHeaderBuilder
implements Serializer {
    private final ImportanceBlockFooterBuilder importanceBlockFooter;

    protected ImportanceBlockHeaderBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.importanceBlockFooter = ImportanceBlockFooterBuilder.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static ImportanceBlockHeaderBuilder loadFromBinary(DataInputStream stream) {
        return new ImportanceBlockHeaderBuilder(stream);
    }

    protected ImportanceBlockHeaderBuilder(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, BlockTypeDto type, HeightDto height, TimestampDto timestamp, DifficultyDto difficulty, VrfProofBuilder generationHashProof, Hash256Dto previousBlockHash, Hash256Dto transactionsHash, Hash256Dto receiptsHash, Hash256Dto stateHash, AddressDto beneficiaryAddress, BlockFeeMultiplierDto feeMultiplier, int votingEligibleAccountsCount, long harvestingEligibleAccountsCount, AmountDto totalVotingBalance, Hash256Dto previousImportanceBlockHash) {
        super(signature, signerPublicKey, version, network, type, height, timestamp, difficulty, generationHashProof, previousBlockHash, transactionsHash, receiptsHash, stateHash, beneficiaryAddress, feeMultiplier);
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(height, "height is null", new Object[0]);
        GeneratorUtils.notNull(timestamp, "timestamp is null", new Object[0]);
        GeneratorUtils.notNull(difficulty, "difficulty is null", new Object[0]);
        GeneratorUtils.notNull(generationHashProof, "generationHashProof is null", new Object[0]);
        GeneratorUtils.notNull(previousBlockHash, "previousBlockHash is null", new Object[0]);
        GeneratorUtils.notNull(transactionsHash, "transactionsHash is null", new Object[0]);
        GeneratorUtils.notNull(receiptsHash, "receiptsHash is null", new Object[0]);
        GeneratorUtils.notNull(stateHash, "stateHash is null", new Object[0]);
        GeneratorUtils.notNull(beneficiaryAddress, "beneficiaryAddress is null", new Object[0]);
        GeneratorUtils.notNull(feeMultiplier, "feeMultiplier is null", new Object[0]);
        GeneratorUtils.notNull(votingEligibleAccountsCount, "votingEligibleAccountsCount is null", new Object[0]);
        GeneratorUtils.notNull(harvestingEligibleAccountsCount, "harvestingEligibleAccountsCount is null", new Object[0]);
        GeneratorUtils.notNull(totalVotingBalance, "totalVotingBalance is null", new Object[0]);
        GeneratorUtils.notNull(previousImportanceBlockHash, "previousImportanceBlockHash is null", new Object[0]);
        this.importanceBlockFooter = new ImportanceBlockFooterBuilder(votingEligibleAccountsCount, harvestingEligibleAccountsCount, totalVotingBalance, previousImportanceBlockHash);
    }

    public static ImportanceBlockHeaderBuilder create(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, BlockTypeDto type, HeightDto height, TimestampDto timestamp, DifficultyDto difficulty, VrfProofBuilder generationHashProof, Hash256Dto previousBlockHash, Hash256Dto transactionsHash, Hash256Dto receiptsHash, Hash256Dto stateHash, AddressDto beneficiaryAddress, BlockFeeMultiplierDto feeMultiplier, int votingEligibleAccountsCount, long harvestingEligibleAccountsCount, AmountDto totalVotingBalance, Hash256Dto previousImportanceBlockHash) {
        return new ImportanceBlockHeaderBuilder(signature, signerPublicKey, version, network, type, height, timestamp, difficulty, generationHashProof, previousBlockHash, transactionsHash, receiptsHash, stateHash, beneficiaryAddress, feeMultiplier, votingEligibleAccountsCount, harvestingEligibleAccountsCount, totalVotingBalance, previousImportanceBlockHash);
    }

    public int getVotingEligibleAccountsCount() {
        return this.importanceBlockFooter.getVotingEligibleAccountsCount();
    }

    public long getHarvestingEligibleAccountsCount() {
        return this.importanceBlockFooter.getHarvestingEligibleAccountsCount();
    }

    public AmountDto getTotalVotingBalance() {
        return this.importanceBlockFooter.getTotalVotingBalance();
    }

    public Hash256Dto getPreviousImportanceBlockHash() {
        return this.importanceBlockFooter.getPreviousImportanceBlockHash();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.importanceBlockFooter.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.importanceBlockFooter);
        });
    }
}

