/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicResolutionEntryBuilder;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedMosaicIdDto;
import java.io.DataInputStream;
import java.util.List;

public class MosaicResolutionStatementBuilder
extends ReceiptBuilder
implements Serializer {
    private final UnresolvedMosaicIdDto unresolved;
    private final List<MosaicResolutionEntryBuilder> resolutionEntries;

    protected MosaicResolutionStatementBuilder(DataInputStream stream) {
        super(stream);
        try {
            this.unresolved = UnresolvedMosaicIdDto.loadFromBinary(stream);
            this.resolutionEntries = GeneratorUtils.loadFromBinaryArrayRemaining(MosaicResolutionEntryBuilder::loadFromBinary, stream, 0);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static MosaicResolutionStatementBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicResolutionStatementBuilder(stream);
    }

    protected MosaicResolutionStatementBuilder(short version, ReceiptTypeDto type, UnresolvedMosaicIdDto unresolved, List<MosaicResolutionEntryBuilder> resolutionEntries) {
        super(version, type);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(unresolved, "unresolved is null", new Object[0]);
        GeneratorUtils.notNull(resolutionEntries, "resolutionEntries is null", new Object[0]);
        this.unresolved = unresolved;
        this.resolutionEntries = resolutionEntries;
    }

    public static MosaicResolutionStatementBuilder create(short version, ReceiptTypeDto type, UnresolvedMosaicIdDto unresolved, List<MosaicResolutionEntryBuilder> resolutionEntries) {
        return new MosaicResolutionStatementBuilder(version, type, unresolved, resolutionEntries);
    }

    public UnresolvedMosaicIdDto getUnresolved() {
        return this.unresolved;
    }

    public List<MosaicResolutionEntryBuilder> getResolutionEntries() {
        return this.resolutionEntries;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        size += this.unresolved.getSize();
        return size += GeneratorUtils.getSumSize(this.resolutionEntries, 0);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            GeneratorUtils.writeEntity(dataOutputStream, this.unresolved);
            GeneratorUtils.writeList(dataOutputStream, this.resolutionEntries, 0);
        });
    }
}

