/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BlockDurationDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.NamespaceRegistrationTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public class NamespaceRegistrationTransactionBodyBuilder
implements Serializer {
    private BlockDurationDto duration;
    private NamespaceIdDto parentId;
    private final NamespaceIdDto id;
    private final NamespaceRegistrationTypeDto registrationType;
    private final ByteBuffer name;

    protected NamespaceRegistrationTransactionBodyBuilder(DataInputStream stream) {
        try {
            long registrationTypeCondition = Long.reverseBytes(stream.readLong());
            this.id = NamespaceIdDto.loadFromBinary(stream);
            this.registrationType = NamespaceRegistrationTypeDto.loadFromBinary(stream);
            byte nameSize = stream.readByte();
            this.name = GeneratorUtils.readByteBuffer(stream, nameSize);
            if (this.registrationType == NamespaceRegistrationTypeDto.ROOT) {
                this.duration = new BlockDurationDto(registrationTypeCondition);
            }
            if (this.registrationType == NamespaceRegistrationTypeDto.CHILD) {
                this.parentId = new NamespaceIdDto(registrationTypeCondition);
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static NamespaceRegistrationTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new NamespaceRegistrationTransactionBodyBuilder(stream);
    }

    protected NamespaceRegistrationTransactionBodyBuilder(BlockDurationDto duration, NamespaceIdDto parentId, NamespaceIdDto id, NamespaceRegistrationTypeDto registrationType, ByteBuffer name) {
        if (registrationType == NamespaceRegistrationTypeDto.ROOT) {
            GeneratorUtils.notNull(duration, "duration is null", new Object[0]);
        }
        if (registrationType == NamespaceRegistrationTypeDto.CHILD) {
            GeneratorUtils.notNull(parentId, "parentId is null", new Object[0]);
        }
        GeneratorUtils.notNull(id, "id is null", new Object[0]);
        GeneratorUtils.notNull(registrationType, "registrationType is null", new Object[0]);
        GeneratorUtils.notNull(name, "name is null", new Object[0]);
        this.duration = duration;
        this.parentId = parentId;
        this.id = id;
        this.registrationType = registrationType;
        this.name = name;
    }

    public static NamespaceRegistrationTransactionBodyBuilder createCHILD(NamespaceIdDto parentId, NamespaceIdDto id, ByteBuffer name) {
        NamespaceRegistrationTypeDto registrationType = NamespaceRegistrationTypeDto.CHILD;
        return new NamespaceRegistrationTransactionBodyBuilder(null, parentId, id, registrationType, name);
    }

    public static NamespaceRegistrationTransactionBodyBuilder createROOT(BlockDurationDto duration, NamespaceIdDto id, ByteBuffer name) {
        NamespaceRegistrationTypeDto registrationType = NamespaceRegistrationTypeDto.ROOT;
        return new NamespaceRegistrationTransactionBodyBuilder(duration, null, id, registrationType, name);
    }

    public BlockDurationDto getDuration() {
        if (this.registrationType != NamespaceRegistrationTypeDto.ROOT) {
            throw new IllegalStateException("registrationType is not set to ROOT.");
        }
        return this.duration;
    }

    public NamespaceIdDto getParentId() {
        if (this.registrationType != NamespaceRegistrationTypeDto.CHILD) {
            throw new IllegalStateException("registrationType is not set to CHILD.");
        }
        return this.parentId;
    }

    public NamespaceIdDto getId() {
        return this.id;
    }

    public NamespaceRegistrationTypeDto getRegistrationType() {
        return this.registrationType;
    }

    public ByteBuffer getName() {
        return this.name;
    }

    @Override
    public int getSize() {
        int size = 0;
        if (this.registrationType == NamespaceRegistrationTypeDto.ROOT) {
            size += this.duration.getSize();
        }
        if (this.registrationType == NamespaceRegistrationTypeDto.CHILD) {
            size += this.parentId.getSize();
        }
        size += this.id.getSize();
        size += this.registrationType.getSize();
        ++size;
        return size += this.name.array().length;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            if (this.registrationType == NamespaceRegistrationTypeDto.ROOT) {
                GeneratorUtils.writeEntity(dataOutputStream, this.duration);
            }
            if (this.registrationType == NamespaceRegistrationTypeDto.CHILD) {
                GeneratorUtils.writeEntity(dataOutputStream, this.parentId);
            }
            GeneratorUtils.writeEntity(dataOutputStream, this.id);
            GeneratorUtils.writeEntity(dataOutputStream, this.registrationType);
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getName()));
            dataOutputStream.write(this.name.array(), 0, this.name.array().length);
        });
    }
}

