/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.LinkActionDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class NodeKeyLinkTransactionBodyBuilder
implements Serializer {
    private final PublicKeyDto linkedPublicKey;
    private final LinkActionDto linkAction;

    protected NodeKeyLinkTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.linkedPublicKey = PublicKeyDto.loadFromBinary(stream);
            this.linkAction = LinkActionDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static NodeKeyLinkTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new NodeKeyLinkTransactionBodyBuilder(stream);
    }

    protected NodeKeyLinkTransactionBodyBuilder(PublicKeyDto linkedPublicKey, LinkActionDto linkAction) {
        GeneratorUtils.notNull(linkedPublicKey, "linkedPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.linkedPublicKey = linkedPublicKey;
        this.linkAction = linkAction;
    }

    public static NodeKeyLinkTransactionBodyBuilder create(PublicKeyDto linkedPublicKey, LinkActionDto linkAction) {
        return new NodeKeyLinkTransactionBodyBuilder(linkedPublicKey, linkAction);
    }

    public PublicKeyDto getLinkedPublicKey() {
        return this.linkedPublicKey;
    }

    public LinkActionDto getLinkAction() {
        return this.linkAction;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.linkedPublicKey.getSize();
        return size += this.linkAction.getSize();
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.linkedPublicKey);
            GeneratorUtils.writeEntity(dataOutputStream, this.linkAction);
        });
    }
}

