/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class PublicKeyDto
implements Serializer {
    private final ByteBuffer publicKey;

    public PublicKeyDto(ByteBuffer publicKey) {
        this.publicKey = publicKey;
    }

    public PublicKeyDto(DataInputStream stream) {
        try {
            this.publicKey = GeneratorUtils.readByteBuffer(stream, 32);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public ByteBuffer getPublicKey() {
        return this.publicKey;
    }

    @Override
    public int getSize() {
        return 32;
    }

    public static PublicKeyDto loadFromBinary(DataInputStream stream) {
        return new PublicKeyDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.publicKey.array(), 0, this.publicKey.array().length));
    }
}

