/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.PublicKeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.SignatureDto;
import io.nem.symbol.catapult.builders.TimestampDto;
import io.nem.symbol.catapult.builders.TransactionTypeDto;
import java.io.DataInputStream;

public class TransactionBuilder
implements Serializer {
    private int size;
    private final int verifiableEntityHeaderReserved1;
    private final SignatureDto signature;
    private final PublicKeyDto signerPublicKey;
    private final int entityBodyReserved1;
    private final byte version;
    private final NetworkTypeDto network;
    private final TransactionTypeDto type;
    private final AmountDto fee;
    private final TimestampDto deadline;

    protected TransactionBuilder(DataInputStream stream) {
        try {
            this.size = Integer.reverseBytes(stream.readInt());
            this.verifiableEntityHeaderReserved1 = Integer.reverseBytes(stream.readInt());
            this.signature = SignatureDto.loadFromBinary(stream);
            this.signerPublicKey = PublicKeyDto.loadFromBinary(stream);
            this.entityBodyReserved1 = Integer.reverseBytes(stream.readInt());
            this.version = stream.readByte();
            this.network = NetworkTypeDto.loadFromBinary(stream);
            this.type = TransactionTypeDto.loadFromBinary(stream);
            this.fee = AmountDto.loadFromBinary(stream);
            this.deadline = TimestampDto.loadFromBinary(stream);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static TransactionBuilder loadFromBinary(DataInputStream stream) {
        return new TransactionBuilder(stream);
    }

    protected TransactionBuilder(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, AmountDto fee, TimestampDto deadline) {
        GeneratorUtils.notNull(signature, "signature is null", new Object[0]);
        GeneratorUtils.notNull(signerPublicKey, "signerPublicKey is null", new Object[0]);
        GeneratorUtils.notNull(version, "version is null", new Object[0]);
        GeneratorUtils.notNull(network, "network is null", new Object[0]);
        GeneratorUtils.notNull(type, "type is null", new Object[0]);
        GeneratorUtils.notNull(fee, "fee is null", new Object[0]);
        GeneratorUtils.notNull(deadline, "deadline is null", new Object[0]);
        this.verifiableEntityHeaderReserved1 = 0;
        this.signature = signature;
        this.signerPublicKey = signerPublicKey;
        this.entityBodyReserved1 = 0;
        this.version = version;
        this.network = network;
        this.type = type;
        this.fee = fee;
        this.deadline = deadline;
    }

    public static TransactionBuilder create(SignatureDto signature, PublicKeyDto signerPublicKey, byte version, NetworkTypeDto network, TransactionTypeDto type, AmountDto fee, TimestampDto deadline) {
        return new TransactionBuilder(signature, signerPublicKey, version, network, type, fee, deadline);
    }

    public int getStreamSize() {
        return this.size;
    }

    private int getVerifiableEntityHeaderReserved1() {
        return this.verifiableEntityHeaderReserved1;
    }

    public SignatureDto getSignature() {
        return this.signature;
    }

    public PublicKeyDto getSignerPublicKey() {
        return this.signerPublicKey;
    }

    private int getEntityBodyReserved1() {
        return this.entityBodyReserved1;
    }

    public byte getVersion() {
        return this.version;
    }

    public NetworkTypeDto getNetwork() {
        return this.network;
    }

    public TransactionTypeDto getType() {
        return this.type;
    }

    public AmountDto getFee() {
        return this.fee;
    }

    public TimestampDto getDeadline() {
        return this.deadline;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += 4;
        size += 4;
        size += this.signature.getSize();
        size += this.signerPublicKey.getSize();
        size += 4;
        ++size;
        size += this.network.getSize();
        size += this.type.getSize();
        size += this.fee.getSize();
        return size += this.deadline.getSize();
    }

    public Serializer getBody() {
        return null;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            dataOutputStream.writeInt(Integer.reverseBytes(this.getSize()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getVerifiableEntityHeaderReserved1()));
            GeneratorUtils.writeEntity(dataOutputStream, this.signature);
            GeneratorUtils.writeEntity(dataOutputStream, this.signerPublicKey);
            dataOutputStream.writeInt(Integer.reverseBytes(this.getEntityBodyReserved1()));
            dataOutputStream.writeByte(this.getVersion());
            GeneratorUtils.writeEntity(dataOutputStream, this.network);
            GeneratorUtils.writeEntity(dataOutputStream, this.type);
            GeneratorUtils.writeEntity(dataOutputStream, this.fee);
            GeneratorUtils.writeEntity(dataOutputStream, this.deadline);
        });
    }
}

