/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedAddressDto;
import io.nem.symbol.catapult.builders.UnresolvedMosaicBuilder;
import java.io.DataInputStream;
import java.nio.ByteBuffer;
import java.util.List;

public class TransferTransactionBodyBuilder
implements Serializer {
    private final UnresolvedAddressDto recipientAddress;
    private final int transferTransactionBodyReserved1;
    private final byte transferTransactionBodyReserved2;
    private final List<UnresolvedMosaicBuilder> mosaics;
    private final ByteBuffer message;

    protected TransferTransactionBodyBuilder(DataInputStream stream) {
        try {
            this.recipientAddress = UnresolvedAddressDto.loadFromBinary(stream);
            short messageSize = Short.reverseBytes(stream.readShort());
            byte mosaicsCount = stream.readByte();
            this.transferTransactionBodyReserved1 = Integer.reverseBytes(stream.readInt());
            this.transferTransactionBodyReserved2 = stream.readByte();
            this.mosaics = GeneratorUtils.loadFromBinaryArray(UnresolvedMosaicBuilder::loadFromBinary, stream, mosaicsCount, 0);
            this.message = GeneratorUtils.readByteBuffer(stream, messageSize);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public static TransferTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new TransferTransactionBodyBuilder(stream);
    }

    protected TransferTransactionBodyBuilder(UnresolvedAddressDto recipientAddress, List<UnresolvedMosaicBuilder> mosaics, ByteBuffer message) {
        GeneratorUtils.notNull(recipientAddress, "recipientAddress is null", new Object[0]);
        GeneratorUtils.notNull(mosaics, "mosaics is null", new Object[0]);
        GeneratorUtils.notNull(message, "message is null", new Object[0]);
        this.recipientAddress = recipientAddress;
        this.transferTransactionBodyReserved1 = 0;
        this.transferTransactionBodyReserved2 = 0;
        this.mosaics = mosaics;
        this.message = message;
    }

    public static TransferTransactionBodyBuilder create(UnresolvedAddressDto recipientAddress, List<UnresolvedMosaicBuilder> mosaics, ByteBuffer message) {
        return new TransferTransactionBodyBuilder(recipientAddress, mosaics, message);
    }

    public UnresolvedAddressDto getRecipientAddress() {
        return this.recipientAddress;
    }

    private int getTransferTransactionBodyReserved1() {
        return this.transferTransactionBodyReserved1;
    }

    private byte getTransferTransactionBodyReserved2() {
        return this.transferTransactionBodyReserved2;
    }

    public List<UnresolvedMosaicBuilder> getMosaics() {
        return this.mosaics;
    }

    public ByteBuffer getMessage() {
        return this.message;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.recipientAddress.getSize();
        size += 2;
        ++size;
        size += 4;
        ++size;
        size += GeneratorUtils.getSumSize(this.mosaics, 0);
        return size += this.message.array().length;
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            GeneratorUtils.writeEntity(dataOutputStream, this.recipientAddress);
            dataOutputStream.writeShort(Short.reverseBytes((short)GeneratorUtils.getSize(this.getMessage())));
            dataOutputStream.writeByte((byte)GeneratorUtils.getSize(this.getMosaics()));
            dataOutputStream.writeInt(Integer.reverseBytes(this.getTransferTransactionBodyReserved1()));
            dataOutputStream.writeByte(this.getTransferTransactionBodyReserved2());
            GeneratorUtils.writeList(dataOutputStream, this.mosaics, 0);
            dataOutputStream.write(this.message.array(), 0, this.message.array().length);
        });
    }
}

