/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import java.io.DataInputStream;

public enum AccountLinkActionDto {
    UNLINK(0),
    LINK(1);

    private final byte value;

    public byte getValue() {
        return this.value;
    }

    private AccountLinkActionDto(byte value) {
        this.value = value;
    }

    public static AccountLinkActionDto rawValueOf(byte value) {
        for (AccountLinkActionDto current : AccountLinkActionDto.values()) {
            if (value != current.value) continue;
            return current;
        }
        throw new IllegalArgumentException(value + " was not a backing value for AccountLinkActionDto.");
    }

    public int getSize() {
        return 1;
    }

    public static AccountLinkActionDto loadFromBinary(DataInputStream stream) {
        try {
            byte streamValue = stream.readByte();
            return AccountLinkActionDto.rawValueOf(streamValue);
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.writeByte(this.value));
    }
}

