/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountLinkActionDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class AccountLinkTransactionBodyBuilder
implements Serializer {
    private final KeyDto remotePublicKey;
    private final AccountLinkActionDto linkAction;

    protected AccountLinkTransactionBodyBuilder(DataInputStream stream) {
        this.remotePublicKey = KeyDto.loadFromBinary(stream);
        this.linkAction = AccountLinkActionDto.loadFromBinary(stream);
    }

    protected AccountLinkTransactionBodyBuilder(KeyDto remotePublicKey, AccountLinkActionDto linkAction) {
        GeneratorUtils.notNull(remotePublicKey, "remotePublicKey is null", new Object[0]);
        GeneratorUtils.notNull(linkAction, "linkAction is null", new Object[0]);
        this.remotePublicKey = remotePublicKey;
        this.linkAction = linkAction;
    }

    public static AccountLinkTransactionBodyBuilder create(KeyDto remotePublicKey, AccountLinkActionDto linkAction) {
        return new AccountLinkTransactionBodyBuilder(remotePublicKey, linkAction);
    }

    public KeyDto getRemotePublicKey() {
        return this.remotePublicKey;
    }

    public AccountLinkActionDto getLinkAction() {
        return this.linkAction;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.remotePublicKey.getSize();
        return size += this.linkAction.getSize();
    }

    public static AccountLinkTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AccountLinkTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] remotePublicKeyBytes = this.remotePublicKey.serialize();
            dataOutputStream.write(remotePublicKeyBytes, 0, remotePublicKeyBytes.length);
            byte[] linkActionBytes = this.linkAction.serialize();
            dataOutputStream.write(linkActionBytes, 0, linkActionBytes.length);
        });
    }
}

