/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AccountRestrictionFlagsDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedMosaicIdDto;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public final class AccountMosaicRestrictionTransactionBodyBuilder
implements Serializer {
    private final EnumSet<AccountRestrictionFlagsDto> restrictionFlags;
    private final int accountRestrictionTransactionBody_Reserved1;
    private final List<UnresolvedMosaicIdDto> restrictionAdditions;
    private final List<UnresolvedMosaicIdDto> restrictionDeletions;

    protected AccountMosaicRestrictionTransactionBodyBuilder(DataInputStream stream) {
        try {
            int i;
            this.restrictionFlags = GeneratorUtils.toSet(AccountRestrictionFlagsDto.class, Short.reverseBytes(stream.readShort()));
            int restrictionAdditionsCount = stream.readByte();
            int restrictionDeletionsCount = stream.readByte();
            this.accountRestrictionTransactionBody_Reserved1 = Integer.reverseBytes(stream.readInt());
            this.restrictionAdditions = new ArrayList<UnresolvedMosaicIdDto>(restrictionAdditionsCount);
            for (i = 0; i < restrictionAdditionsCount; ++i) {
                this.restrictionAdditions.add(UnresolvedMosaicIdDto.loadFromBinary(stream));
            }
            this.restrictionDeletions = new ArrayList<UnresolvedMosaicIdDto>(restrictionDeletionsCount);
            for (i = 0; i < restrictionDeletionsCount; ++i) {
                this.restrictionDeletions.add(UnresolvedMosaicIdDto.loadFromBinary(stream));
            }
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    protected AccountMosaicRestrictionTransactionBodyBuilder(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, List<UnresolvedMosaicIdDto> restrictionAdditions, List<UnresolvedMosaicIdDto> restrictionDeletions) {
        GeneratorUtils.notNull(restrictionFlags, "restrictionFlags is null", new Object[0]);
        GeneratorUtils.notNull(restrictionAdditions, "restrictionAdditions is null", new Object[0]);
        GeneratorUtils.notNull(restrictionDeletions, "restrictionDeletions is null", new Object[0]);
        this.restrictionFlags = restrictionFlags;
        this.accountRestrictionTransactionBody_Reserved1 = 0;
        this.restrictionAdditions = restrictionAdditions;
        this.restrictionDeletions = restrictionDeletions;
    }

    public static AccountMosaicRestrictionTransactionBodyBuilder create(EnumSet<AccountRestrictionFlagsDto> restrictionFlags, List<UnresolvedMosaicIdDto> restrictionAdditions, List<UnresolvedMosaicIdDto> restrictionDeletions) {
        return new AccountMosaicRestrictionTransactionBodyBuilder(restrictionFlags, restrictionAdditions, restrictionDeletions);
    }

    public EnumSet<AccountRestrictionFlagsDto> getRestrictionFlags() {
        return this.restrictionFlags;
    }

    private int getAccountRestrictionTransactionBody_Reserved1() {
        return this.accountRestrictionTransactionBody_Reserved1;
    }

    public List<UnresolvedMosaicIdDto> getRestrictionAdditions() {
        return this.restrictionAdditions;
    }

    public List<UnresolvedMosaicIdDto> getRestrictionDeletions() {
        return this.restrictionDeletions;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += AccountRestrictionFlagsDto.values()[0].getSize();
        ++size;
        ++size;
        size += 4;
        size += this.restrictionAdditions.stream().mapToInt(o -> o.getSize()).sum();
        return size += this.restrictionDeletions.stream().mapToInt(o -> o.getSize()).sum();
    }

    public static AccountMosaicRestrictionTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new AccountMosaicRestrictionTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            int i;
            short bitMask = (short)GeneratorUtils.toLong(AccountRestrictionFlagsDto.class, this.restrictionFlags);
            dataOutputStream.writeShort(Short.reverseBytes(bitMask));
            dataOutputStream.writeByte((byte)this.restrictionAdditions.size());
            dataOutputStream.writeByte((byte)this.restrictionDeletions.size());
            dataOutputStream.writeInt(Integer.reverseBytes(this.getAccountRestrictionTransactionBody_Reserved1()));
            for (i = 0; i < this.restrictionAdditions.size(); ++i) {
                byte[] restrictionAdditionsBytes = this.restrictionAdditions.get(i).serialize();
                dataOutputStream.write(restrictionAdditionsBytes, 0, restrictionAdditionsBytes.length);
            }
            for (i = 0; i < this.restrictionDeletions.size(); ++i) {
                byte[] restrictionDeletionsBytes = this.restrictionDeletions.get(i).serialize();
                dataOutputStream.write(restrictionDeletionsBytes, 0, restrictionDeletionsBytes.length);
            }
        });
    }
}

