/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.NamespaceMetadataTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class EmbeddedNamespaceMetadataTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final NamespaceMetadataTransactionBodyBuilder namespaceMetadataTransactionBody;

    protected EmbeddedNamespaceMetadataTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.namespaceMetadataTransactionBody = NamespaceMetadataTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected EmbeddedNamespaceMetadataTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto targetPublicKey, long scopedMetadataKey, NamespaceIdDto targetNamespaceId, short valueSizeDelta, ByteBuffer value) {
        super(signerPublicKey, version, network, type);
        this.namespaceMetadataTransactionBody = NamespaceMetadataTransactionBodyBuilder.create(targetPublicKey, scopedMetadataKey, targetNamespaceId, valueSizeDelta, value);
    }

    public static EmbeddedNamespaceMetadataTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, KeyDto targetPublicKey, long scopedMetadataKey, NamespaceIdDto targetNamespaceId, short valueSizeDelta, ByteBuffer value) {
        return new EmbeddedNamespaceMetadataTransactionBuilder(signerPublicKey, version, network, type, targetPublicKey, scopedMetadataKey, targetNamespaceId, valueSizeDelta, value);
    }

    public KeyDto getTargetPublicKey() {
        return this.namespaceMetadataTransactionBody.getTargetPublicKey();
    }

    public long getScopedMetadataKey() {
        return this.namespaceMetadataTransactionBody.getScopedMetadataKey();
    }

    public NamespaceIdDto getTargetNamespaceId() {
        return this.namespaceMetadataTransactionBody.getTargetNamespaceId();
    }

    public short getValueSizeDelta() {
        return this.namespaceMetadataTransactionBody.getValueSizeDelta();
    }

    public ByteBuffer getValue() {
        return this.namespaceMetadataTransactionBody.getValue();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.namespaceMetadataTransactionBody.getSize();
    }

    @Override
    public NamespaceMetadataTransactionBodyBuilder getBody() {
        return this.namespaceMetadataTransactionBody;
    }

    public static EmbeddedNamespaceMetadataTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedNamespaceMetadataTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] namespaceMetadataTransactionBodyBytes = this.namespaceMetadataTransactionBody.serialize();
            dataOutputStream.write(namespaceMetadataTransactionBodyBytes, 0, namespaceMetadataTransactionBodyBytes.length);
        });
    }
}

