/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.BlockDurationDto;
import io.nem.symbol.catapult.builders.EmbeddedTransactionBuilder;
import io.nem.symbol.catapult.builders.EntityTypeDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.KeyDto;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.NamespaceRegistrationTransactionBodyBuilder;
import io.nem.symbol.catapult.builders.NamespaceRegistrationTypeDto;
import io.nem.symbol.catapult.builders.NetworkTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class EmbeddedNamespaceRegistrationTransactionBuilder
extends EmbeddedTransactionBuilder
implements Serializer {
    private final NamespaceRegistrationTransactionBodyBuilder namespaceRegistrationTransactionBody;

    protected EmbeddedNamespaceRegistrationTransactionBuilder(DataInputStream stream) {
        super(stream);
        this.namespaceRegistrationTransactionBody = NamespaceRegistrationTransactionBodyBuilder.loadFromBinary(stream);
    }

    protected EmbeddedNamespaceRegistrationTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, BlockDurationDto duration, NamespaceIdDto id, ByteBuffer name) {
        super(signerPublicKey, version, network, type);
        this.namespaceRegistrationTransactionBody = NamespaceRegistrationTransactionBodyBuilder.create(duration, id, name);
    }

    protected EmbeddedNamespaceRegistrationTransactionBuilder(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, NamespaceIdDto parentId, NamespaceIdDto id, ByteBuffer name) {
        super(signerPublicKey, version, network, type);
        this.namespaceRegistrationTransactionBody = NamespaceRegistrationTransactionBodyBuilder.create(parentId, id, name);
    }

    public static EmbeddedNamespaceRegistrationTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, BlockDurationDto duration, NamespaceIdDto id, ByteBuffer name) {
        return new EmbeddedNamespaceRegistrationTransactionBuilder(signerPublicKey, version, network, type, duration, id, name);
    }

    public static EmbeddedNamespaceRegistrationTransactionBuilder create(KeyDto signerPublicKey, byte version, NetworkTypeDto network, EntityTypeDto type, NamespaceIdDto parentId, NamespaceIdDto id, ByteBuffer name) {
        return new EmbeddedNamespaceRegistrationTransactionBuilder(signerPublicKey, version, network, type, parentId, id, name);
    }

    public BlockDurationDto getDuration() {
        return this.namespaceRegistrationTransactionBody.getDuration();
    }

    public NamespaceIdDto getParentId() {
        return this.namespaceRegistrationTransactionBody.getParentId();
    }

    public NamespaceIdDto getId() {
        return this.namespaceRegistrationTransactionBody.getId();
    }

    public NamespaceRegistrationTypeDto getRegistrationType() {
        return this.namespaceRegistrationTransactionBody.getRegistrationType();
    }

    public ByteBuffer getName() {
        return this.namespaceRegistrationTransactionBody.getName();
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.namespaceRegistrationTransactionBody.getSize();
    }

    @Override
    public NamespaceRegistrationTransactionBodyBuilder getBody() {
        return this.namespaceRegistrationTransactionBody;
    }

    public static EmbeddedNamespaceRegistrationTransactionBuilder loadFromBinary(DataInputStream stream) {
        return new EmbeddedNamespaceRegistrationTransactionBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] namespaceRegistrationTransactionBodyBytes = this.namespaceRegistrationTransactionBody.serialize();
            dataOutputStream.write(namespaceRegistrationTransactionBodyBytes, 0, namespaceRegistrationTransactionBodyBytes.length);
        });
    }
}

