/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicIdDto;
import io.nem.symbol.catapult.builders.ReceiptSourceBuilder;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public class MosaicResolutionEntryBuilder
implements Serializer {
    private final ReceiptSourceBuilder source;
    private final MosaicIdDto resolved;

    protected MosaicResolutionEntryBuilder(DataInputStream stream) {
        this.source = ReceiptSourceBuilder.loadFromBinary(stream);
        this.resolved = MosaicIdDto.loadFromBinary(stream);
    }

    protected MosaicResolutionEntryBuilder(ReceiptSourceBuilder source, MosaicIdDto resolved) {
        GeneratorUtils.notNull(source, "source is null", new Object[0]);
        GeneratorUtils.notNull(resolved, "resolved is null", new Object[0]);
        this.source = source;
        this.resolved = resolved;
    }

    public static MosaicResolutionEntryBuilder create(ReceiptSourceBuilder source, MosaicIdDto resolved) {
        return new MosaicResolutionEntryBuilder(source, resolved);
    }

    public ReceiptSourceBuilder getSource() {
        return this.source;
    }

    public MosaicIdDto getResolved() {
        return this.resolved;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.source.getSize();
        return size += this.resolved.getSize();
    }

    public static MosaicResolutionEntryBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicResolutionEntryBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] sourceBytes = this.source.serialize();
            dataOutputStream.write(sourceBytes, 0, sourceBytes.length);
            byte[] resolvedBytes = this.resolved.serialize();
            dataOutputStream.write(resolvedBytes, 0, resolvedBytes.length);
        });
    }
}

