/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.AmountDto;
import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.MosaicSupplyChangeActionDto;
import io.nem.symbol.catapult.builders.Serializer;
import io.nem.symbol.catapult.builders.UnresolvedMosaicIdDto;
import java.io.DataInputStream;

public final class MosaicSupplyChangeTransactionBodyBuilder
implements Serializer {
    private final UnresolvedMosaicIdDto mosaicId;
    private final AmountDto delta;
    private final MosaicSupplyChangeActionDto action;

    protected MosaicSupplyChangeTransactionBodyBuilder(DataInputStream stream) {
        this.mosaicId = UnresolvedMosaicIdDto.loadFromBinary(stream);
        this.delta = AmountDto.loadFromBinary(stream);
        this.action = MosaicSupplyChangeActionDto.loadFromBinary(stream);
    }

    protected MosaicSupplyChangeTransactionBodyBuilder(UnresolvedMosaicIdDto mosaicId, AmountDto delta, MosaicSupplyChangeActionDto action) {
        GeneratorUtils.notNull(mosaicId, "mosaicId is null", new Object[0]);
        GeneratorUtils.notNull(delta, "delta is null", new Object[0]);
        GeneratorUtils.notNull(action, "action is null", new Object[0]);
        this.mosaicId = mosaicId;
        this.delta = delta;
        this.action = action;
    }

    public static MosaicSupplyChangeTransactionBodyBuilder create(UnresolvedMosaicIdDto mosaicId, AmountDto delta, MosaicSupplyChangeActionDto action) {
        return new MosaicSupplyChangeTransactionBodyBuilder(mosaicId, delta, action);
    }

    public UnresolvedMosaicIdDto getMosaicId() {
        return this.mosaicId;
    }

    public AmountDto getDelta() {
        return this.delta;
    }

    public MosaicSupplyChangeActionDto getAction() {
        return this.action;
    }

    @Override
    public int getSize() {
        int size = 0;
        size += this.mosaicId.getSize();
        size += this.delta.getSize();
        return size += this.action.getSize();
    }

    public static MosaicSupplyChangeTransactionBodyBuilder loadFromBinary(DataInputStream stream) {
        return new MosaicSupplyChangeTransactionBodyBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] mosaicIdBytes = this.mosaicId.serialize();
            dataOutputStream.write(mosaicIdBytes, 0, mosaicIdBytes.length);
            byte[] deltaBytes = this.delta.serialize();
            dataOutputStream.write(deltaBytes, 0, deltaBytes.length);
            byte[] actionBytes = this.action.serialize();
            dataOutputStream.write(actionBytes, 0, actionBytes.length);
        });
    }
}

