/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.NamespaceIdDto;
import io.nem.symbol.catapult.builders.ReceiptBuilder;
import io.nem.symbol.catapult.builders.ReceiptTypeDto;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;

public final class NamespaceExpiryReceiptBuilder
extends ReceiptBuilder
implements Serializer {
    private final NamespaceIdDto artifactId;

    protected NamespaceExpiryReceiptBuilder(DataInputStream stream) {
        super(stream);
        this.artifactId = NamespaceIdDto.loadFromBinary(stream);
    }

    protected NamespaceExpiryReceiptBuilder(short version, ReceiptTypeDto type, NamespaceIdDto artifactId) {
        super(version, type);
        GeneratorUtils.notNull(artifactId, "artifactId is null", new Object[0]);
        this.artifactId = artifactId;
    }

    public static NamespaceExpiryReceiptBuilder create(short version, ReceiptTypeDto type, NamespaceIdDto artifactId) {
        return new NamespaceExpiryReceiptBuilder(version, type, artifactId);
    }

    public NamespaceIdDto getArtifactId() {
        return this.artifactId;
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        return size += this.artifactId.getSize();
    }

    public static NamespaceExpiryReceiptBuilder loadFromBinary(DataInputStream stream) {
        return new NamespaceExpiryReceiptBuilder(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> {
            byte[] superBytes = super.serialize();
            dataOutputStream.write(superBytes, 0, superBytes.length);
            byte[] artifactIdBytes = this.artifactId.serialize();
            dataOutputStream.write(artifactIdBytes, 0, artifactIdBytes.length);
        });
    }
}

