/*
 * Decompiled with CFR 0.152.
 */
package io.nem.symbol.catapult.builders;

import io.nem.symbol.catapult.builders.GeneratorUtils;
import io.nem.symbol.catapult.builders.Serializer;
import java.io.DataInputStream;
import java.nio.ByteBuffer;

public final class UnresolvedAddressDto
implements Serializer {
    private final ByteBuffer unresolvedAddress;

    public UnresolvedAddressDto(ByteBuffer unresolvedAddress) {
        GeneratorUtils.notNull(unresolvedAddress, "unresolvedAddress is null", new Object[0]);
        GeneratorUtils.isTrue(unresolvedAddress.array().length == 25, "unresolvedAddress should be 25 bytes", new Object[0]);
        this.unresolvedAddress = unresolvedAddress;
    }

    public UnresolvedAddressDto(DataInputStream stream) {
        try {
            this.unresolvedAddress = ByteBuffer.allocate(25);
            stream.readFully(this.unresolvedAddress.array());
        }
        catch (Exception e) {
            throw GeneratorUtils.getExceptionToPropagate(e);
        }
    }

    public ByteBuffer getUnresolvedAddress() {
        return this.unresolvedAddress;
    }

    @Override
    public int getSize() {
        return 25;
    }

    public static UnresolvedAddressDto loadFromBinary(DataInputStream stream) {
        return new UnresolvedAddressDto(stream);
    }

    @Override
    public byte[] serialize() {
        return GeneratorUtils.serialize(dataOutputStream -> dataOutputStream.write(this.unresolvedAddress.array(), 0, this.unresolvedAddress.array().length));
    }
}

