/*
 * Decompiled with CFR 0.152.
 */
package io.objectbox.query;

import io.objectbox.Box;
import io.objectbox.BoxStore;
import io.objectbox.annotation.apihint.Internal;
import io.objectbox.query.Query;
import io.objectbox.reactive.DataObserver;
import io.objectbox.reactive.DataPublisher;
import io.objectbox.reactive.DataPublisherUtils;
import io.objectbox.reactive.DataSubscription;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.Nullable;

@Internal
class QueryPublisher<T>
implements DataPublisher<List<T>> {
    private final Query<T> query;
    private final Box<T> box;
    private final Set<DataObserver<List<T>>> observers = new CopyOnWriteArraySet<DataObserver<List<T>>>();
    private DataObserver<Class<T>> objectClassObserver;
    private DataSubscription objectClassSubscription;

    QueryPublisher(Query<T> query, Box<T> box) {
        this.query = query;
        this.box = box;
    }

    @Override
    public synchronized void subscribe(DataObserver<List<T>> observer, @Nullable Object param) {
        BoxStore store = this.box.getStore();
        if (this.objectClassObserver == null) {
            this.objectClassObserver = objectClass -> this.publish();
        }
        if (this.observers.isEmpty()) {
            if (this.objectClassSubscription != null) {
                throw new IllegalStateException("Existing subscription found");
            }
            this.objectClassSubscription = store.subscribe(this.box.getEntityClass()).weak().onlyChanges().observer(this.objectClassObserver);
        }
        this.observers.add(observer);
    }

    @Override
    public void publishSingle(DataObserver<List<T>> observer, @Nullable Object param) {
        this.box.getStore().internalScheduleThread(() -> {
            List<T> result = this.query.find();
            observer.onData(result);
        });
    }

    void publish() {
        this.box.getStore().internalScheduleThread(() -> {
            List<T> result = this.query.find();
            for (DataObserver<List<List<T>>> dataObserver : this.observers) {
                dataObserver.onData(result);
            }
        });
    }

    @Override
    public synchronized void unsubscribe(DataObserver<List<T>> observer, @Nullable Object param) {
        DataPublisherUtils.removeObserverFromCopyOnWriteSet(this.observers, observer);
        if (this.observers.isEmpty()) {
            this.objectClassSubscription.cancel();
            this.objectClassSubscription = null;
        }
    }
}

