/*
 * Decompiled with CFR 0.152.
 */
package io.ocfl.api;

import io.ocfl.api.model.DigestAlgorithm;
import io.ocfl.api.util.Enforce;
import java.util.HashMap;
import java.util.Map;

public final class DigestAlgorithmRegistry {
    private static final Map<String, DigestAlgorithm> REGISTRY = new HashMap<String, DigestAlgorithm>(Map.of(DigestAlgorithm.md5.getOcflName(), DigestAlgorithm.md5, DigestAlgorithm.sha1.getOcflName(), DigestAlgorithm.sha1, DigestAlgorithm.sha256.getOcflName(), DigestAlgorithm.sha256, DigestAlgorithm.sha512.getOcflName(), DigestAlgorithm.sha512, DigestAlgorithm.blake2b512.getOcflName(), DigestAlgorithm.blake2b512, DigestAlgorithm.blake2b160.getOcflName(), DigestAlgorithm.blake2b160, DigestAlgorithm.blake2b256.getOcflName(), DigestAlgorithm.blake2b256, DigestAlgorithm.blake2b384.getOcflName(), DigestAlgorithm.blake2b384, DigestAlgorithm.sha512_256.getOcflName(), DigestAlgorithm.sha512_256));

    private DigestAlgorithmRegistry() {
    }

    public static void register(DigestAlgorithm algorithm) {
        Enforce.notNull(algorithm, "algorithm cannot be null");
        REGISTRY.put(algorithm.getOcflName(), algorithm);
    }

    public static DigestAlgorithm getAlgorithm(String ocflName) {
        Enforce.notBlank(ocflName, "ocflName cannot be blank");
        return REGISTRY.get(ocflName.toLowerCase());
    }
}

