/*
 * Decompiled with CFR 0.152.
 */
package io.ocfl.api.exception;

import io.ocfl.api.exception.OcflJavaException;
import io.ocfl.api.model.ValidationIssue;
import io.ocfl.api.model.ValidationResults;
import java.util.List;

public class ValidationException
extends OcflJavaException {
    private final ValidationResults validationResults;

    public ValidationException(String message, ValidationResults results) {
        super(message);
        this.validationResults = results;
    }

    public ValidationResults getValidationResults() {
        return this.validationResults;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder(super.getMessage());
        builder.append("\nErrors:\n");
        this.printIssues(this.validationResults.getErrors(), builder);
        if (this.validationResults.hasWarnings()) {
            builder.append("\nWarnings:\n");
            this.printIssues(this.validationResults.getWarnings(), builder);
        }
        if (this.validationResults.hasInfos()) {
            builder.append("\nInfos:\n");
            this.printIssues(this.validationResults.getInfos(), builder);
        }
        return builder.toString();
    }

    private void printIssues(List<ValidationIssue> issues, StringBuilder builder) {
        for (int i = 1; i <= issues.size(); ++i) {
            builder.append(" ").append(i).append(". ");
            builder.append(issues.get(i - 1).toString());
            if (i >= issues.size()) continue;
            builder.append("\n");
        }
    }
}

