/*
 * Decompiled with CFR 0.152.
 */
package io.ocfl.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.ocfl.api.model.ValidationCode;
import io.ocfl.api.util.Enforce;

public class ValidationIssue {
    private final ValidationCode code;
    private final String message;

    @JsonCreator
    public ValidationIssue(@JsonProperty(value="code") ValidationCode code, @JsonProperty(value="message") String message) {
        this.code = Enforce.notNull(code, "code cannot be null");
        this.message = Enforce.notBlank(message, "message cannot be blank");
    }

    public ValidationCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return String.format("[%s] %s", new Object[]{this.code, this.message});
    }
}

