/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.client;

import io.reactivesocket.ReactiveSocket;
import io.reactivesocket.client.LoadBalancer;
import io.reactivesocket.client.ReactiveSocketClient;
import java.util.Collection;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

final class LoadBalancerInitializer
implements ReactiveSocketClient,
Runnable {
    private final LoadBalancer loadBalancer;
    private final MonoProcessor<ReactiveSocket> emitSource = MonoProcessor.create();

    private LoadBalancerInitializer(Publisher<? extends Collection<ReactiveSocketClient>> factories) {
        this.loadBalancer = new LoadBalancer(factories, this);
    }

    static LoadBalancerInitializer create(Publisher<? extends Collection<ReactiveSocketClient>> factories) {
        return new LoadBalancerInitializer(factories);
    }

    public Mono<ReactiveSocket> connect() {
        return this.emitSource;
    }

    @Override
    public void run() {
        this.emitSource.onNext((Object)this.loadBalancer);
    }

    public synchronized double availability() {
        return this.emitSource.isTerminated() ? 1.0 : 0.0;
    }
}

