/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.client;

import io.reactivesocket.ReactiveSocket;
import io.reactivesocket.client.LoadBalancerInitializer;
import io.reactivesocket.client.ReactiveSocketClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class LoadBalancingClient
implements ReactiveSocketClient {
    private final LoadBalancerInitializer initializer;

    public LoadBalancingClient(LoadBalancerInitializer initializer) {
        this.initializer = initializer;
    }

    public Mono<? extends ReactiveSocket> connect() {
        return this.initializer.connect();
    }

    public double availability() {
        return this.initializer.availability();
    }

    public static <T> LoadBalancingClient create(Publisher<? extends Collection<T>> servers, Function<T, ReactiveSocketClient> clientFactory) {
        SourceToClient<T> f = new SourceToClient<T>(clientFactory);
        return new LoadBalancingClient(LoadBalancerInitializer.create((Publisher<? extends Collection<ReactiveSocketClient>>)Flux.from(servers).map(f)));
    }

    public static final class SourceToClient<T>
    implements Function<Collection<T>, Collection<ReactiveSocketClient>> {
        private final Function<T, ReactiveSocketClient> tToClient;
        private Map<T, ReactiveSocketClient> seenClients;

        public SourceToClient(Function<T, ReactiveSocketClient> tToClient) {
            this.tToClient = tToClient;
            this.seenClients = Collections.emptyMap();
        }

        @Override
        public Collection<ReactiveSocketClient> apply(Collection<T> servers) {
            HashMap<T, ReactiveSocketClient> next = new HashMap<T, ReactiveSocketClient>(servers.size());
            for (T server : servers) {
                ReactiveSocketClient client = this.seenClients.get(server);
                if (client == null) {
                    ReactiveSocketClient newClient = this.tToClient.apply(server);
                    next.put(server, newClient);
                    continue;
                }
                next.put(server, client);
            }
            this.seenClients.clear();
            this.seenClients = next;
            return new ArrayList<ReactiveSocketClient>(this.seenClients.values());
        }
    }
}

