/*
 * Decompiled with CFR 0.152.
 */
package io.reactivesocket.client.filter;

import io.reactivesocket.ReactiveSocket;
import io.reactivesocket.client.ReactiveSocketClient;
import io.reactivesocket.client.filter.FailureAwareClient;
import java.time.Duration;
import java.util.function.Function;
import reactor.core.publisher.Mono;

public final class ReactiveSocketClients {
    private ReactiveSocketClients() {
    }

    public static ReactiveSocketClient connectTimeout(final ReactiveSocketClient orig, final Duration timeout) {
        return new ReactiveSocketClient(){

            public Mono<? extends ReactiveSocket> connect() {
                return orig.connect().timeout(timeout);
            }

            public double availability() {
                return orig.availability();
            }
        };
    }

    public static ReactiveSocketClient detectFailures(ReactiveSocketClient orig) {
        return new FailureAwareClient(orig);
    }

    public static ReactiveSocketClient wrap(final ReactiveSocketClient orig, final Function<ReactiveSocket, ReactiveSocket> mapper) {
        return new ReactiveSocketClient(){

            public Mono<? extends ReactiveSocket> connect() {
                return orig.connect().map(mapper);
            }

            public double availability() {
                return orig.availability();
            }
        };
    }
}

