/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rx.Observable;
import rx.Subscriber;
import rx.internal.operators.SingleDelayedProducer;

public final class OperatorToObservableList<T>
implements Observable.Operator<List<T>, T> {
    public static <T> OperatorToObservableList<T> instance() {
        return Holder.INSTANCE;
    }

    private OperatorToObservableList() {
    }

    @Override
    public Subscriber<? super T> call(final Subscriber<? super List<T>> o) {
        final SingleDelayedProducer<? super List<T>> producer = new SingleDelayedProducer<List<T>>(o);
        Subscriber result = new Subscriber<T>(){
            boolean completed = false;
            List<T> list = new LinkedList();

            @Override
            public void onStart() {
                this.request(Long.MAX_VALUE);
            }

            @Override
            public void onCompleted() {
                if (!this.completed) {
                    ArrayList result;
                    this.completed = true;
                    try {
                        result = new ArrayList(this.list);
                    }
                    catch (Throwable t) {
                        this.onError(t);
                        return;
                    }
                    this.list = null;
                    producer.set(result);
                }
            }

            @Override
            public void onError(Throwable e) {
                o.onError(e);
            }

            @Override
            public void onNext(T value) {
                if (!this.completed) {
                    this.list.add(value);
                }
            }
        };
        o.add(result);
        o.setProducer(producer);
        return result;
    }

    private static final class Holder {
        static final OperatorToObservableList<Object> INSTANCE = new OperatorToObservableList();

        private Holder() {
        }
    }
}

