/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Deque;
import java.util.concurrent.atomic.AtomicLong;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;

final class TakeLastQueueProducer<T>
extends AtomicLong
implements Producer {
    private final NotificationLite<T> notification;
    private final Deque<Object> deque;
    private final Subscriber<? super T> subscriber;
    private volatile boolean emittingStarted = false;

    public TakeLastQueueProducer(NotificationLite<T> n, Deque<Object> q, Subscriber<? super T> subscriber) {
        this.notification = n;
        this.deque = q;
        this.subscriber = subscriber;
    }

    void startEmitting() {
        if (!this.emittingStarted) {
            this.emittingStarted = true;
            this.emit(0L);
        }
    }

    @Override
    public void request(long n) {
        if (this.get() == Long.MAX_VALUE) {
            return;
        }
        long _c = n == Long.MAX_VALUE ? this.getAndSet(Long.MAX_VALUE) : BackpressureUtils.getAndAddRequest(this, n);
        if (!this.emittingStarted) {
            return;
        }
        this.emit(_c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void emit(long previousRequested) {
        if (this.get() == Long.MAX_VALUE) {
            if (previousRequested == 0L) {
                try {
                    for (Object value : this.deque) {
                        if (this.subscriber.isUnsubscribed()) {
                            return;
                        }
                        this.notification.accept(this.subscriber, value);
                    }
                }
                catch (Throwable e) {
                    Exceptions.throwOrReport(e, this.subscriber);
                }
                finally {
                    this.deque.clear();
                }
            }
        } else if (previousRequested == 0L) {
            block7: while (true) {
                long newRequested;
                long oldRequested;
                Object o;
                long numToEmit = this.get();
                int emitted = 0;
                while (--numToEmit >= 0L && (o = this.deque.poll()) != null) {
                    if (this.subscriber.isUnsubscribed()) {
                        return;
                    }
                    if (this.notification.accept(this.subscriber, o)) {
                        return;
                    }
                    ++emitted;
                }
                do {
                    oldRequested = this.get();
                    newRequested = oldRequested - (long)emitted;
                    if (oldRequested == Long.MAX_VALUE) continue block7;
                } while (!this.compareAndSet(oldRequested, newRequested));
                if (newRequested == 0L) break;
            }
            return;
        }
    }
}

