/**
 * Copyright 2016 Netflix, Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See
 * the License for the specific language governing permissions and limitations under the License.
 */

package io.reactivex.internal.operators.completable;

import org.reactivestreams.Subscriber;

import io.reactivex.*;
import io.reactivex.internal.subscribers.completable.SubscriberCompletableObserver;

public final class CompletableToFlowable<T> extends Flowable<T> {

    final CompletableSource source;
    
    public CompletableToFlowable(CompletableSource source) {
        this.source = source;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        SubscriberCompletableObserver<T> os = new SubscriberCompletableObserver<T>(s);
        source.subscribe(os);
    }
}
