/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.util.ExceptionHelper;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public enum CompletableAwait {


    public static void await(CompletableSource cc) {
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        cc.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e) {
                err[0] = e;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Disposable d) {
            }
        });
        if (cdl.getCount() == 0L) {
            if (err[0] != null) {
                throw ExceptionHelper.wrapOrThrow(err[0]);
            }
            return;
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (err[0] != null) {
            throw ExceptionHelper.wrapOrThrow(err[0]);
        }
    }

    public static boolean await(CompletableSource cc, long timeout, TimeUnit unit) {
        boolean b;
        ObjectHelper.requireNonNull(unit, "unit is null");
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        cc.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e) {
                err[0] = e;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Disposable d) {
            }
        });
        if (cdl.getCount() == 0L) {
            if (err[0] != null) {
                throw ExceptionHelper.wrapOrThrow(err[0]);
            }
            return true;
        }
        try {
            b = cdl.await(timeout, unit);
        }
        catch (InterruptedException ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (b && err[0] != null) {
            throw ExceptionHelper.wrapOrThrow(err[0]);
        }
        return b;
    }

    public static Throwable get(CompletableSource cc) {
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        cc.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e) {
                err[0] = e;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Disposable d) {
            }
        });
        if (cdl.getCount() == 0L) {
            return err[0];
        }
        try {
            cdl.await();
        }
        catch (InterruptedException ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return err[0];
    }

    public static Throwable get(CompletableSource cc, long timeout, TimeUnit unit) {
        boolean b;
        ObjectHelper.requireNonNull(unit, "unit is null");
        final CountDownLatch cdl = new CountDownLatch(1);
        final Throwable[] err = new Throwable[1];
        cc.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                cdl.countDown();
            }

            @Override
            public void onError(Throwable e) {
                err[0] = e;
                cdl.countDown();
            }

            @Override
            public void onSubscribe(Disposable d) {
            }
        });
        if (cdl.getCount() == 0L) {
            return err[0];
        }
        try {
            b = cdl.await(timeout, unit);
        }
        catch (InterruptedException ex) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (b) {
            return err[0];
        }
        throw ExceptionHelper.wrapOrThrow(new TimeoutException());
    }
}

