/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.util.concurrent.Callable;

public final class CompletableErrorSupplier
extends Completable {
    final Callable<? extends Throwable> errorSupplier;

    public CompletableErrorSupplier(Callable<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    protected void subscribeActual(CompletableObserver s) {
        Throwable error;
        try {
            error = this.errorSupplier.call();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            error = e;
        }
        if (error == null) {
            error = new NullPointerException("The error supplied is null");
        }
        EmptyDisposable.error(error, s);
    }
}

