/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.flowables.ConnectableFlowable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableRefCount<T>
extends AbstractFlowableWithUpstream<T, T> {
    final ConnectableFlowable<? extends T> source;
    volatile CompositeDisposable baseSubscription = new CompositeDisposable();
    final AtomicInteger subscriptionCount = new AtomicInteger(0);
    final ReentrantLock lock = new ReentrantLock();

    public FlowableRefCount(ConnectableFlowable<T> source) {
        super(source);
        this.source = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribeActual(Subscriber<? super T> subscriber) {
        this.lock.lock();
        if (this.subscriptionCount.incrementAndGet() == 1) {
            AtomicBoolean writeLocked = new AtomicBoolean(true);
            try {
                this.source.connect(this.onSubscribe(subscriber, writeLocked));
            }
            finally {
                if (writeLocked.get()) {
                    this.lock.unlock();
                }
            }
        }
        try {
            this.doSubscribe(subscriber, this.baseSubscription);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Consumer<Disposable> onSubscribe(final Subscriber<? super T> subscriber, final AtomicBoolean writeLocked) {
        return new Consumer<Disposable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Disposable subscription) {
                try {
                    FlowableRefCount.this.baseSubscription.add(subscription);
                    FlowableRefCount.this.doSubscribe(subscriber, FlowableRefCount.this.baseSubscription);
                }
                finally {
                    FlowableRefCount.this.lock.unlock();
                    writeLocked.set(false);
                }
            }
        };
    }

    void doSubscribe(Subscriber<? super T> subscriber, CompositeDisposable currentBase) {
        Disposable d = this.disconnect(currentBase);
        ConnectionSubscriber s = new ConnectionSubscriber(subscriber, currentBase, d);
        this.source.subscribe(s);
    }

    private Disposable disconnect(final CompositeDisposable current) {
        return Disposables.fromRunnable(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FlowableRefCount.this.lock.lock();
                try {
                    if (FlowableRefCount.this.baseSubscription == current && FlowableRefCount.this.subscriptionCount.decrementAndGet() == 0) {
                        FlowableRefCount.this.baseSubscription.dispose();
                        FlowableRefCount.this.baseSubscription = new CompositeDisposable();
                    }
                }
                finally {
                    FlowableRefCount.this.lock.unlock();
                }
            }
        });
    }

    final class ConnectionSubscriber
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super T> subscriber;
        final CompositeDisposable currentBase;
        final Disposable resource;
        Subscription s;

        ConnectionSubscriber(Subscriber<? super T> subscriber, CompositeDisposable currentBase, Disposable resource) {
            this.subscriber = subscriber;
            this.currentBase = currentBase;
            this.resource = resource;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.subscriber.onSubscribe((Subscription)this);
            }
        }

        public void onError(Throwable e) {
            this.cleanup();
            this.subscriber.onError(e);
        }

        public void onNext(T t) {
            this.subscriber.onNext(t);
        }

        public void onComplete() {
            this.cleanup();
            this.subscriber.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
            this.resource.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanup() {
            FlowableRefCount.this.lock.lock();
            try {
                if (FlowableRefCount.this.baseSubscription == this.currentBase) {
                    FlowableRefCount.this.baseSubscription.dispose();
                    FlowableRefCount.this.baseSubscription = new CompositeDisposable();
                    FlowableRefCount.this.subscriptionCount.set(0);
                }
            }
            finally {
                FlowableRefCount.this.lock.unlock();
            }
        }
    }
}

