/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableScan<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BiFunction<T, T, T> accumulator;

    public FlowableScan(Publisher<T> source, BiFunction<T, T, T> accumulator) {
        super(source);
        this.accumulator = accumulator;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new ScanSubscriber<T>(s, this.accumulator));
    }

    static final class ScanSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        final BiFunction<T, T, T> accumulator;
        Subscription s;
        T value;

        public ScanSubscriber(Subscriber<? super T> actual, BiFunction<T, T, T> accumulator) {
            this.actual = actual;
            this.accumulator = accumulator;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            Subscriber<? super T> a = this.actual;
            T v = this.value;
            if (v == null) {
                this.value = t;
                a.onNext(t);
            } else {
                T u;
                try {
                    u = this.accumulator.apply(v, t);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.s.cancel();
                    a.onError(e);
                    return;
                }
                if (u == null) {
                    this.s.cancel();
                    a.onError((Throwable)new NullPointerException("The value returned by the accumulator is null"));
                    return;
                }
                this.value = u;
                a.onNext(u);
            }
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

