/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.ArrayCompositeSubscription;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSkipUntil<T, U>
extends AbstractFlowableWithUpstream<T, T> {
    final Publisher<U> other;

    public FlowableSkipUntil(Publisher<T> source, Publisher<U> other) {
        super(source);
        this.other = other;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> child) {
        final SerializedSubscriber<? super T> serial = new SerializedSubscriber<T>(child);
        final ArrayCompositeSubscription frc = new ArrayCompositeSubscription(2);
        final SkipUntilSubscriber<? super T> sus = new SkipUntilSubscriber<T>(serial, frc);
        this.other.subscribe(new Subscriber<U>(){
            Subscription s;

            public void onSubscribe(Subscription s) {
                if (SubscriptionHelper.validate(this.s, s)) {
                    this.s = s;
                    if (frc.setResource(1, s)) {
                        s.request(Long.MAX_VALUE);
                    }
                }
            }

            public void onNext(U t) {
                this.s.cancel();
                sus.notSkipping = true;
            }

            public void onError(Throwable t) {
                frc.dispose();
                if (sus.compareAndSet(false, true)) {
                    EmptySubscription.error(t, serial);
                } else {
                    serial.onError(t);
                }
            }

            public void onComplete() {
                sus.notSkipping = true;
            }
        });
        this.source.subscribe(sus);
    }

    static final class SkipUntilSubscriber<T>
    extends AtomicBoolean
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -1113667257122396604L;
        final Subscriber<? super T> actual;
        final ArrayCompositeSubscription frc;
        Subscription s;
        volatile boolean notSkipping;
        boolean notSkippingLocal;

        public SkipUntilSubscriber(Subscriber<? super T> actual, ArrayCompositeSubscription frc) {
            this.actual = actual;
            this.frc = frc;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                if (this.frc.setResource(0, s) && this.compareAndSet(false, true)) {
                    this.actual.onSubscribe((Subscription)this);
                }
            }
        }

        public void onNext(T t) {
            if (this.notSkippingLocal) {
                this.actual.onNext(t);
            } else if (this.notSkipping) {
                this.notSkippingLocal = true;
                this.actual.onNext(t);
            } else {
                this.s.request(1L);
            }
        }

        public void onError(Throwable t) {
            this.frc.dispose();
            this.actual.onError(t);
        }

        public void onComplete() {
            this.frc.dispose();
            this.actual.onComplete();
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.frc.dispose();
        }
    }
}

