/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Scheduler;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableTakeLastTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long count;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;
    final int bufferSize;
    final boolean delayError;

    public FlowableTakeLastTimed(Publisher<T> source, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
        super(source);
        this.count = count;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new TakeLastTimedSubscriber<T>(s, this.count, this.time, this.unit, this.scheduler, this.bufferSize, this.delayError));
    }

    static final class TakeLastTimedSubscriber<T>
    extends AtomicInteger
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = -5677354903406201275L;
        final Subscriber<? super T> actual;
        final long count;
        final long time;
        final TimeUnit unit;
        final Scheduler scheduler;
        final SpscLinkedArrayQueue<Object> queue;
        final boolean delayError;
        Subscription s;
        final AtomicLong requested = new AtomicLong();
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;

        public TakeLastTimedSubscriber(Subscriber<? super T> actual, long count, long time, TimeUnit unit, Scheduler scheduler, int bufferSize, boolean delayError) {
            this.actual = actual;
            this.count = count;
            this.time = time;
            this.unit = unit;
            this.scheduler = scheduler;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.delayError = delayError;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            SpscLinkedArrayQueue<Object> q = this.queue;
            long now = this.scheduler.now(this.unit);
            q.offer(now, t);
            this.trim(now, q);
        }

        public void onError(Throwable t) {
            if (this.delayError) {
                this.trim(this.scheduler.now(this.unit), this.queue);
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            this.trim(this.scheduler.now(this.unit), this.queue);
            this.done = true;
            this.drain();
        }

        void trim(long now, SpscLinkedArrayQueue<Object> q) {
            long ts;
            boolean unbounded;
            long time = this.time;
            long c = this.count;
            boolean bl = unbounded = c == Long.MAX_VALUE;
            while (!q.isEmpty() && ((ts = ((Long)q.peek()).longValue()) < now - time || !unbounded && (long)(q.size() >> 1) > c)) {
                q.poll();
                q.poll();
            }
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
                this.drain();
            }
        }

        public void cancel() {
            if (this.cancelled) {
                this.cancelled = true;
                if (this.getAndIncrement() == 0) {
                    this.queue.clear();
                    this.s.cancel();
                }
            }
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<? super T> a = this.actual;
            SpscLinkedArrayQueue<Object> q = this.queue;
            boolean delayError = this.delayError;
            do {
                if (!this.done) continue;
                boolean empty = q.isEmpty();
                if (this.checkTerminated(empty, a, delayError)) {
                    return;
                }
                long r = this.requested.get();
                boolean unbounded = r == Long.MAX_VALUE;
                long e = 0L;
                while (true) {
                    Object ts;
                    boolean bl = empty = (ts = q.peek()) == null;
                    if (this.checkTerminated(empty, a, delayError)) {
                        return;
                    }
                    if (empty || r == 0L) break;
                    q.poll();
                    Object o = q.poll();
                    if (o == null) {
                        this.s.cancel();
                        a.onError((Throwable)new IllegalStateException("Queue empty?!"));
                        return;
                    }
                    a.onNext(o);
                    --r;
                    --e;
                }
                if (e == 0L || unbounded) continue;
                this.requested.addAndGet(e);
            } while ((missed = this.addAndGet(-missed)) != 0);
        }

        boolean checkTerminated(boolean empty, Subscriber<? super T> a, boolean delayError) {
            if (this.cancelled) {
                this.queue.clear();
                this.s.cancel();
                return true;
            }
            if (delayError) {
                if (empty) {
                    Throwable e = this.error;
                    if (e != null) {
                        a.onError(e);
                    } else {
                        a.onComplete();
                    }
                    return true;
                }
            } else {
                Throwable e = this.error;
                if (e != null) {
                    this.queue.clear();
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }
    }
}

