/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;

public final class SingleDoOnSubscribe<T>
extends Single<T> {
    final SingleSource<T> source;
    final Consumer<? super Disposable> onSubscribe;

    public SingleDoOnSubscribe(SingleSource<T> source, Consumer<? super Disposable> onSubscribe) {
        this.source = source;
        this.onSubscribe = onSubscribe;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        this.source.subscribe(new SingleObserver<T>(){
            boolean done;

            @Override
            public void onSubscribe(Disposable d) {
                try {
                    SingleDoOnSubscribe.this.onSubscribe.accept(d);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.done = true;
                    d.dispose();
                    EmptyDisposable.error(ex, s);
                    return;
                }
                s.onSubscribe(d);
            }

            @Override
            public void onSuccess(T value) {
                if (this.done) {
                    return;
                }
                s.onSuccess(value);
            }

            @Override
            public void onError(Throwable e) {
                if (this.done) {
                    RxJavaPlugins.onError(e);
                    return;
                }
                s.onError(e);
            }
        });
    }
}

