/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.observers;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;

public final class SafeObserver<T>
implements Observer<T>,
Disposable {
    final Observer<? super T> actual;
    Disposable s;
    boolean done;

    public SafeObserver(Observer<? super T> actual) {
        this.actual = actual;
    }

    @Override
    public void onSubscribe(Disposable s) {
        if (DisposableHelper.validate(this.s, s)) {
            this.s = s;
            try {
                this.actual.onSubscribe(this);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.done = true;
                try {
                    s.dispose();
                }
                catch (Throwable e1) {
                    Exceptions.throwIfFatal(e1);
                    RxJavaPlugins.onError(new CompositeException(e, e1));
                    return;
                }
                RxJavaPlugins.onError(e);
            }
        }
    }

    @Override
    public void dispose() {
        this.s.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.s.isDisposed();
    }

    @Override
    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (this.s == null) {
            this.onNextNoSubscription();
            return;
        }
        if (t == null) {
            NullPointerException ex = new NullPointerException();
            try {
                this.s.dispose();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                this.onError(new CompositeException(ex, e1));
                return;
            }
            this.onError(ex);
            return;
        }
        try {
            this.actual.onNext(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                this.s.dispose();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                this.onError(new CompositeException(e, e1));
                return;
            }
            this.onError(e);
        }
    }

    void onNextNoSubscription() {
        this.done = true;
        NullPointerException ex = new NullPointerException("Subscription not set!");
        try {
            this.actual.onSubscribe(EmptyDisposable.INSTANCE);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
            return;
        }
        try {
            this.actual.onError(ex);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
        }
    }

    @Override
    public void onError(Throwable t) {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.s == null) {
            CompositeException t2 = new CompositeException(t, new NullPointerException("Subscription not set!"));
            try {
                this.actual.onSubscribe(EmptyDisposable.INSTANCE);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                t2.suppress(e);
                RxJavaPlugins.onError(t2);
                return;
            }
            try {
                this.actual.onError(t2);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                t2.suppress(e);
                RxJavaPlugins.onError(t2);
            }
            return;
        }
        if (t == null) {
            t = new NullPointerException();
        }
        try {
            this.actual.onError(t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(new CompositeException(t, ex));
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.s == null) {
            this.onCompleteNoSubscription();
            return;
        }
        try {
            this.actual.onComplete();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
        }
    }

    void onCompleteNoSubscription() {
        NullPointerException ex = new NullPointerException("Subscription not set!");
        try {
            this.actual.onSubscribe(EmptyDisposable.INSTANCE);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
            return;
        }
        try {
            this.actual.onError(ex);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
        }
    }
}

