/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.subscribers;

import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public abstract class ResourceSubscriber<T>
implements Subscriber<T>,
Disposable {
    private final AtomicReference<Subscription> s = new AtomicReference();
    private final CompositeDisposable resources = new CompositeDisposable();
    private final AtomicLong missedRequested = new AtomicLong();

    public final void add(Disposable resource) {
        ObjectHelper.requireNonNull(resource, "resource is null");
        this.resources.add(resource);
    }

    public final void onSubscribe(Subscription s) {
        if (SubscriptionHelper.setOnce(this.s, s)) {
            long mr = this.missedRequested.getAndSet(0L);
            if (mr != 0L) {
                s.request(mr);
            }
            this.onStart();
        }
    }

    protected void onStart() {
        this.request(Long.MAX_VALUE);
    }

    protected final void request(long n) {
        if (!SubscriptionHelper.validate(n)) {
            return;
        }
        Subscription a = this.s.get();
        if (a == null) {
            long mr;
            BackpressureHelper.add(this.missedRequested, n);
            a = this.s.get();
            if (a != null && (mr = this.missedRequested.getAndSet(0L)) != 0L) {
                a.request(mr);
            }
        } else {
            a.request(n);
        }
    }

    protected final void cancel() {
        if (SubscriptionHelper.cancel(this.s)) {
            this.resources.dispose();
        }
    }

    @Override
    public final void dispose() {
        this.cancel();
    }

    @Override
    public final boolean isDisposed() {
        return SubscriptionHelper.isCancelled(this.s.get());
    }
}

