/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.completable;

import io.reactivex.Completable;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;

public final class CompletableDoOnEvent
extends Completable {
    final CompletableSource source;
    final Consumer<? super Throwable> onEvent;

    public CompletableDoOnEvent(CompletableSource source, Consumer<? super Throwable> onEvent) {
        this.source = source;
        this.onEvent = onEvent;
    }

    @Override
    protected void subscribeActual(final CompletableObserver s) {
        this.source.subscribe(new CompletableObserver(){

            @Override
            public void onComplete() {
                try {
                    CompletableDoOnEvent.this.onEvent.accept(null);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    s.onError(e);
                    return;
                }
                s.onComplete();
            }

            @Override
            public void onError(Throwable e) {
                try {
                    CompletableDoOnEvent.this.onEvent.accept(e);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    e = new CompositeException(ex, e);
                }
                s.onError(e);
            }

            @Override
            public void onSubscribe(Disposable d) {
                s.onSubscribe(d);
            }
        });
    }
}

