/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableMapNotification<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends R> onNextMapper;
    final Function<? super Throwable, ? extends R> onErrorMapper;
    final Callable<? extends R> onCompleteSupplier;

    public FlowableMapNotification(Publisher<T> source, Function<? super T, ? extends R> onNextMapper, Function<? super Throwable, ? extends R> onErrorMapper, Callable<? extends R> onCompleteSupplier) {
        super(source);
        this.onNextMapper = onNextMapper;
        this.onErrorMapper = onErrorMapper;
        this.onCompleteSupplier = onCompleteSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s) {
        this.source.subscribe(new MapNotificationSubscriber<T, R>(s, this.onNextMapper, this.onErrorMapper, this.onCompleteSupplier));
    }

    static final class MapNotificationSubscriber<T, R>
    extends AtomicLong
    implements Subscriber<T>,
    Subscription {
        private static final long serialVersionUID = 2757120512858778108L;
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends R> onNextMapper;
        final Function<? super Throwable, ? extends R> onErrorMapper;
        final Callable<? extends R> onCompleteSupplier;
        Subscription s;
        R value;
        volatile boolean done;
        final AtomicInteger state = new AtomicInteger();
        static final int NO_REQUEST_NO_VALUE = 0;
        static final int NO_REQUEST_HAS_VALUE = 1;
        static final int HAS_REQUEST_NO_VALUE = 2;
        static final int HAS_REQUEST_HAS_VALUE = 3;

        MapNotificationSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends R> onNextMapper, Function<? super Throwable, ? extends R> onErrorMapper, Callable<? extends R> onCompleteSupplier) {
            this.actual = actual;
            this.onNextMapper = onNextMapper;
            this.onErrorMapper = onErrorMapper;
            this.onCompleteSupplier = onCompleteSupplier;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            R p;
            try {
                p = this.onNextMapper.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            if (p == null) {
                this.actual.onError((Throwable)new NullPointerException("The onNext publisher returned is null"));
                return;
            }
            this.actual.onNext(p);
            long r = this.get();
            if (r != Long.MAX_VALUE) {
                this.decrementAndGet();
            }
        }

        public void onError(Throwable t) {
            R p;
            try {
                p = this.onErrorMapper.apply(t);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            if (p == null) {
                this.actual.onError((Throwable)new NullPointerException("The onError publisher returned is null"));
                return;
            }
            this.tryEmit(p);
        }

        public void onComplete() {
            R p;
            try {
                p = this.onCompleteSupplier.call();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.actual.onError(e);
                return;
            }
            if (p == null) {
                this.actual.onError((Throwable)new NullPointerException("The onComplete publisher returned is null"));
                return;
            }
            this.tryEmit(p);
        }

        void tryEmit(R p) {
            long r = this.get();
            if (r == 0L) {
                while (true) {
                    int s;
                    if ((s = this.state.get()) == 2) {
                        if (this.state.compareAndSet(2, 3)) {
                            this.actual.onNext(p);
                            this.actual.onComplete();
                        }
                        return;
                    }
                    if (s == 0) {
                        this.value = p;
                        this.done = true;
                        if (!this.state.compareAndSet(0, 1)) continue;
                        return;
                    }
                    if (s == 1 || s == 3) break;
                }
                return;
            }
            this.actual.onNext(p);
            this.actual.onComplete();
        }

        public void request(long n) {
            if (!SubscriptionHelper.validate(n)) {
                return;
            }
            BackpressureHelper.add(this, n);
            if (this.done) {
                do {
                    int s;
                    if ((s = this.state.get()) == 2 || s == 3) {
                        return;
                    }
                    if (s != 1) continue;
                    if (this.state.compareAndSet(1, 3)) {
                        R p = this.value;
                        this.value = null;
                        this.actual.onNext(p);
                        this.actual.onComplete();
                    }
                    return;
                } while (!this.state.compareAndSet(0, 2));
                return;
            }
            this.s.request(n);
        }

        public void cancel() {
            this.state.lazySet(3);
            this.s.cancel();
        }
    }
}

