/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableSampleTimed<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long period;
    final TimeUnit unit;
    final Scheduler scheduler;

    public FlowableSampleTimed(Publisher<T> source, long period, TimeUnit unit, Scheduler scheduler) {
        super(source);
        this.period = period;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        SerializedSubscriber<? super T> serial = new SerializedSubscriber<T>(s);
        this.source.subscribe(new SampleTimedSubscriber<T>(serial, this.period, this.unit, this.scheduler));
    }

    static final class SampleTimedSubscriber<T>
    extends AtomicReference<T>
    implements Subscriber<T>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -3517602651313910099L;
        final Subscriber<? super T> actual;
        final long period;
        final TimeUnit unit;
        final Scheduler scheduler;
        final AtomicLong requested = new AtomicLong();
        final AtomicReference<Disposable> timer = new AtomicReference();
        Subscription s;

        SampleTimedSubscriber(Subscriber<? super T> actual, long period, TimeUnit unit, Scheduler scheduler) {
            this.actual = actual;
            this.period = period;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                if (this.timer.get() == null) {
                    Disposable d = this.scheduler.schedulePeriodicallyDirect(this, this.period, this.period, this.unit);
                    if (!this.timer.compareAndSet(null, d)) {
                        d.dispose();
                        return;
                    }
                    s.request(Long.MAX_VALUE);
                }
            }
        }

        public void onNext(T t) {
            this.lazySet(t);
        }

        public void onError(Throwable t) {
            this.cancelTimer();
            this.actual.onError(t);
        }

        public void onComplete() {
            this.cancelTimer();
            this.actual.onComplete();
        }

        void cancelTimer() {
            DisposableHelper.dispose(this.timer);
        }

        public void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this.requested, n);
            }
        }

        public void cancel() {
            this.cancelTimer();
            this.s.cancel();
        }

        @Override
        public void run() {
            Object value = this.getAndSet(null);
            if (value != null) {
                long r = this.requested.get();
                if (r != 0L) {
                    this.actual.onNext(value);
                    if (r != Long.MAX_VALUE) {
                        this.requested.decrementAndGet();
                    }
                } else {
                    this.cancel();
                    this.actual.onError((Throwable)new IllegalStateException("Couldn't emit value due to lack of requests!"));
                }
            }
        }
    }
}

