/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.internal.disposables.EmptyDisposable;
import java.util.concurrent.Callable;

public final class ObservableError<T>
extends Observable<T> {
    final Callable<? extends Throwable> errorSupplier;

    public ObservableError(Callable<? extends Throwable> errorSupplier) {
        this.errorSupplier = errorSupplier;
    }

    @Override
    public void subscribeActual(Observer<? super T> s) {
        Throwable error;
        try {
            error = this.errorSupplier.call();
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            error = t;
        }
        if (error == null) {
            error = new NullPointerException("Callable returned null throwable. Null values are generally not allowed in 2.x operators and sources.");
        }
        EmptyDisposable.error(error, s);
    }
}

