/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.fuseable.HasUpstreamObservableSource;
import io.reactivex.internal.operators.observable.ObserverResourceWrapper;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.util.ExceptionHelper;
import io.reactivex.internal.util.NotificationLite;
import io.reactivex.observables.ConnectableObservable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservablePublish<T>
extends ConnectableObservable<T>
implements HasUpstreamObservableSource<T> {
    final ObservableSource<T> source;
    final AtomicReference<PublishObserver<T>> current;
    final int bufferSize;
    final ObservableSource<T> onSubscribe;

    public static <T> ConnectableObservable<T> create(ObservableSource<T> source, final int bufferSize) {
        final AtomicReference<PublishObserver<T>> curr = new AtomicReference<PublishObserver<T>>();
        ObservableSource onSubscribe = new ObservableSource<T>(){

            @Override
            public void subscribe(Observer<? super T> child) {
                InnerDisposable inner;
                while (true) {
                    PublishObserver r;
                    if ((r = (PublishObserver)curr.get()) == null || r.isDisposed()) {
                        PublishObserver u = new PublishObserver(curr, bufferSize);
                        if (!curr.compareAndSet(r, u)) continue;
                        r = u;
                    }
                    if (r.add(inner = new InnerDisposable(r, child))) break;
                }
                child.onSubscribe(inner);
            }
        };
        return RxJavaPlugins.onAssembly(new ObservablePublish<T>(onSubscribe, source, curr, bufferSize));
    }

    public static <T, R> Observable<R> create(final ObservableSource<T> source, final Function<? super Observable<T>, ? extends ObservableSource<R>> selector, final int bufferSize) {
        return RxJavaPlugins.onAssembly(new Observable<R>(){

            @Override
            protected void subscribeActual(Observer<? super R> o) {
                ObservableSource target;
                ConnectableObservable op = ObservablePublish.create(source, bufferSize);
                final ObserverResourceWrapper srw = new ObserverResourceWrapper(o);
                try {
                    target = (ObservableSource)selector.apply(op);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    EmptyDisposable.error(ex, srw);
                    return;
                }
                target.subscribe(srw);
                op.connect(new Consumer<Disposable>(){

                    @Override
                    public void accept(Disposable r) {
                        srw.setResource(r);
                    }
                });
            }
        });
    }

    private ObservablePublish(ObservableSource<T> onSubscribe, ObservableSource<T> source, AtomicReference<PublishObserver<T>> current, int bufferSize) {
        this.onSubscribe = onSubscribe;
        this.source = source;
        this.current = current;
        this.bufferSize = bufferSize;
    }

    @Override
    public ObservableSource<T> source() {
        return this.source;
    }

    @Override
    protected void subscribeActual(Observer<? super T> observer) {
        this.onSubscribe.subscribe(observer);
    }

    @Override
    public void connect(Consumer<? super Disposable> connection) {
        PublishObserver<T> ps;
        while ((ps = this.current.get()) == null || ps.isDisposed()) {
            PublishObserver<T> u = new PublishObserver<T>(this.current, this.bufferSize);
            if (!this.current.compareAndSet(ps, u)) continue;
            ps = u;
            break;
        }
        boolean doConnect = !ps.shouldConnect.get() && ps.shouldConnect.compareAndSet(false, true);
        try {
            connection.accept(ps);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        if (doConnect) {
            this.source.subscribe(ps);
        }
    }

    static final class InnerDisposable<T>
    implements Disposable {
        final PublishObserver<T> parent;
        final Observer<? super T> child;
        volatile boolean cancelled;

        InnerDisposable(PublishObserver<T> parent, Observer<? super T> child) {
            this.parent = parent;
            this.child = child;
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.parent.remove(this);
                this.parent.dispatch();
            }
        }
    }

    static final class PublishObserver<T>
    implements Observer<T>,
    Disposable {
        final SpscLinkedArrayQueue<Object> queue;
        final AtomicReference<PublishObserver<T>> current;
        volatile Object terminalEvent;
        static final InnerDisposable[] EMPTY = new InnerDisposable[0];
        static final InnerDisposable[] TERMINATED = new InnerDisposable[0];
        final AtomicReference<InnerDisposable[]> observers;
        final AtomicBoolean shouldConnect;
        boolean emitting;
        boolean missed;
        final AtomicReference<Disposable> s = new AtomicReference();

        PublishObserver(AtomicReference<PublishObserver<T>> current, int bufferSize) {
            this.queue = new SpscLinkedArrayQueue(bufferSize);
            this.observers = new AtomicReference<InnerDisposable[]>(EMPTY);
            this.current = current;
            this.shouldConnect = new AtomicBoolean();
        }

        @Override
        public void dispose() {
            InnerDisposable[] ps;
            if (this.observers.get() != TERMINATED && (ps = this.observers.getAndSet(TERMINATED)) != TERMINATED) {
                this.current.compareAndSet(this, null);
                DisposableHelper.dispose(this.s);
            }
        }

        @Override
        public boolean isDisposed() {
            return this.observers.get() == TERMINATED;
        }

        @Override
        public void onSubscribe(Disposable s) {
            DisposableHelper.setOnce(this.s, s);
        }

        @Override
        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                this.onError(new IllegalStateException("Prefetch queue is full?!"));
            } else {
                this.dispatch();
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.terminalEvent == null) {
                this.terminalEvent = NotificationLite.error(e);
                this.dispatch();
            }
        }

        @Override
        public void onComplete() {
            if (this.terminalEvent == null) {
                this.terminalEvent = NotificationLite.complete();
                this.dispatch();
            }
        }

        boolean add(InnerDisposable<T> producer) {
            InnerDisposable[] u;
            InnerDisposable[] c;
            if (producer == null) {
                throw new NullPointerException();
            }
            do {
                if ((c = this.observers.get()) == TERMINATED) {
                    return false;
                }
                int len = c.length;
                u = new InnerDisposable[len + 1];
                System.arraycopy(c, 0, u, 0, len);
                u[len] = producer;
            } while (!this.observers.compareAndSet(c, u));
            return true;
        }

        void remove(InnerDisposable<T> producer) {
            InnerDisposable[] u;
            InnerDisposable[] c;
            do {
                if ((c = this.observers.get()) == EMPTY || c == TERMINATED) {
                    return;
                }
                int j = -1;
                int len = c.length;
                for (int i = 0; i < len; ++i) {
                    if (!c[i].equals(producer)) continue;
                    j = i;
                    break;
                }
                if (j < 0) {
                    return;
                }
                if (len == 1) {
                    u = EMPTY;
                    continue;
                }
                u = new InnerDisposable[len - 1];
                System.arraycopy(c, 0, u, 0, j);
                System.arraycopy(c, j + 1, u, j, len - j - 1);
            } while (!this.observers.compareAndSet(c, u));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean checkTerminated(Object term, boolean empty) {
            if (term != null) {
                if (NotificationLite.isComplete(term)) {
                    if (empty) {
                        this.current.compareAndSet(this, null);
                        try {
                            for (InnerDisposable ip : this.observers.getAndSet(TERMINATED)) {
                                ip.child.onComplete();
                            }
                        }
                        finally {
                            this.dispose();
                        }
                        return true;
                    }
                } else {
                    Throwable t = NotificationLite.getError(term);
                    this.current.compareAndSet(this, null);
                    try {
                        for (InnerDisposable ip : this.observers.getAndSet(TERMINATED)) {
                            ip.child.onError(t);
                        }
                    }
                    finally {
                        this.dispose();
                    }
                    return true;
                }
            }
            return false;
        }

        /*
         * Exception decompiling
         */
        void dispatch() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [29[UNCONDITIONALDOLOOP]], but top level block is 15[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }
}

