/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiPredicate;
import io.reactivex.internal.disposables.ArrayCompositeDisposable;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;

public final class ObservableSequenceEqual<T>
extends Observable<Boolean> {
    final ObservableSource<? extends T> first;
    final ObservableSource<? extends T> second;
    final BiPredicate<? super T, ? super T> comparer;
    final int bufferSize;

    public ObservableSequenceEqual(ObservableSource<? extends T> first, ObservableSource<? extends T> second, BiPredicate<? super T, ? super T> comparer, int bufferSize) {
        this.first = first;
        this.second = second;
        this.comparer = comparer;
        this.bufferSize = bufferSize;
    }

    @Override
    public void subscribeActual(Observer<? super Boolean> s) {
        EqualCoordinator<T> ec = new EqualCoordinator<T>(s, this.bufferSize, this.first, this.second, this.comparer);
        s.onSubscribe(ec);
        ec.subscribe();
    }

    static final class EqualObserver<T>
    implements Observer<T> {
        final EqualCoordinator<T> parent;
        final SpscLinkedArrayQueue<T> queue;
        final int index;
        volatile boolean done;
        Throwable error;

        EqualObserver(EqualCoordinator<T> parent, int index, int bufferSize) {
            this.parent = parent;
            this.index = index;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
        }

        @Override
        public void onSubscribe(Disposable s) {
            this.parent.setDisposable(s, this.index);
        }

        @Override
        public void onNext(T t) {
            if (!this.queue.offer(t)) {
                this.onError(new IllegalStateException("Queue full?!"));
                return;
            }
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }
    }

    static final class EqualCoordinator<T>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = -6178010334400373240L;
        final Observer<? super Boolean> actual;
        final BiPredicate<? super T, ? super T> comparer;
        final ArrayCompositeDisposable resources;
        final ObservableSource<? extends T> first;
        final ObservableSource<? extends T> second;
        final EqualObserver<T>[] observers;
        volatile boolean cancelled;
        T v1;
        T v2;

        EqualCoordinator(Observer<? super Boolean> actual, int bufferSize, ObservableSource<? extends T> first, ObservableSource<? extends T> second, BiPredicate<? super T, ? super T> comparer) {
            this.actual = actual;
            this.first = first;
            this.second = second;
            this.comparer = comparer;
            EqualObserver[] as = new EqualObserver[2];
            this.observers = as;
            as[0] = new EqualObserver(this, 0, bufferSize);
            as[1] = new EqualObserver(this, 1, bufferSize);
            this.resources = new ArrayCompositeDisposable(2);
        }

        boolean setDisposable(Disposable s, int index) {
            return this.resources.setResource(index, s);
        }

        void subscribe() {
            EqualObserver<T>[] as = this.observers;
            this.first.subscribe(as[0]);
            this.second.subscribe(as[1]);
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.resources.dispose();
                if (this.getAndIncrement() == 0) {
                    EqualObserver<T>[] as = this.observers;
                    as[0].queue.clear();
                    as[1].queue.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void cancel(SpscLinkedArrayQueue<T> q1, SpscLinkedArrayQueue<T> q2) {
            this.cancelled = true;
            q1.clear();
            q2.clear();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            EqualObserver<T>[] as = this.observers;
            EqualObserver<T> s1 = as[0];
            SpscLinkedArrayQueue q1 = s1.queue;
            EqualObserver<T> s2 = as[1];
            SpscLinkedArrayQueue q2 = s2.queue;
            while (true) {
                boolean e2;
                boolean e1;
                Throwable e;
                Throwable e3;
                if (this.cancelled) {
                    q1.clear();
                    q2.clear();
                    return;
                }
                boolean d1 = s1.done;
                if (d1 && (e3 = s1.error) != null) {
                    this.cancel(q1, q2);
                    this.actual.onError(e3);
                    return;
                }
                boolean d2 = s2.done;
                if (d2 && (e = s2.error) != null) {
                    this.cancel(q1, q2);
                    this.actual.onError(e);
                    return;
                }
                if (this.v1 == null) {
                    this.v1 = q1.poll();
                }
                boolean bl = e1 = this.v1 == null;
                if (this.v2 == null) {
                    this.v2 = q2.poll();
                }
                boolean bl2 = e2 = this.v2 == null;
                if (d1 && d2 && e1 && e2) {
                    this.actual.onNext((Boolean)true);
                    this.actual.onComplete();
                    return;
                }
                if (d1 && d2 && e1 != e2) {
                    this.cancel(q1, q2);
                    this.actual.onNext((Boolean)false);
                    this.actual.onComplete();
                    return;
                }
                if (!e1 && !e2) {
                    boolean c;
                    try {
                        c = this.comparer.test(this.v1, this.v2);
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.cancel(q1, q2);
                        this.actual.onError(ex);
                        return;
                    }
                    if (!c) {
                        this.cancel(q1, q2);
                        this.actual.onNext((Boolean)false);
                        this.actual.onComplete();
                        return;
                    }
                    this.v1 = null;
                    this.v2 = null;
                }
                if (!e1 && !e2) continue;
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }
    }
}

