/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import java.util.ArrayDeque;

public final class ObservableTakeLast<T>
extends AbstractObservableWithUpstream<T, T> {
    final int count;

    public ObservableTakeLast(ObservableSource<T> source, int count) {
        super(source);
        this.count = count;
    }

    @Override
    public void subscribeActual(Observer<? super T> t) {
        this.source.subscribe(new TakeLastObserver<T>(t, this.count));
    }

    static final class TakeLastObserver<T>
    extends ArrayDeque<T>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = 7240042530241604978L;
        final Observer<? super T> actual;
        final int count;
        Disposable s;
        volatile boolean cancelled;

        TakeLastObserver(Observer<? super T> actual, int count) {
            this.actual = actual;
            this.count = count;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.count == this.size()) {
                this.poll();
            }
            this.offer(t);
        }

        @Override
        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.cancelled) {
                return;
            }
            Observer a = this.actual;
            while (!this.cancelled) {
                Object v = this.poll();
                if (v == null) {
                    if (!this.cancelled) {
                        a.onComplete();
                    }
                    return;
                }
                a.onNext(v);
            }
            return;
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.dispose();
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }
    }
}

