/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.observers.SerializedObserver;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableWithLatestFrom<T, U, R>
extends AbstractObservableWithUpstream<T, R> {
    final BiFunction<? super T, ? super U, ? extends R> combiner;
    final ObservableSource<? extends U> other;

    public ObservableWithLatestFrom(ObservableSource<T> source, BiFunction<? super T, ? super U, ? extends R> combiner, ObservableSource<? extends U> other) {
        super(source);
        this.combiner = combiner;
        this.other = other;
    }

    @Override
    public void subscribeActual(Observer<? super R> t) {
        SerializedObserver<? super R> serial = new SerializedObserver<R>(t);
        final WithLatestFromObserver<? super T, ? super U, ? extends R> wlf = new WithLatestFromObserver<T, U, R>(serial, this.combiner);
        this.other.subscribe(new Observer<U>(){

            @Override
            public void onSubscribe(Disposable s) {
                wlf.setOther(s);
            }

            @Override
            public void onNext(U t) {
                wlf.lazySet(t);
            }

            @Override
            public void onError(Throwable t) {
                wlf.otherError(t);
            }

            @Override
            public void onComplete() {
            }
        });
        this.source.subscribe(wlf);
    }

    static final class WithLatestFromObserver<T, U, R>
    extends AtomicReference<U>
    implements Observer<T>,
    Disposable {
        private static final long serialVersionUID = -312246233408980075L;
        final Observer<? super R> actual;
        final BiFunction<? super T, ? super U, ? extends R> combiner;
        final AtomicReference<Disposable> s = new AtomicReference();
        final AtomicReference<Disposable> other = new AtomicReference();

        WithLatestFromObserver(Observer<? super R> actual, BiFunction<? super T, ? super U, ? extends R> combiner) {
            this.actual = actual;
            this.combiner = combiner;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.setOnce(this.s, s)) {
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            Object u = this.get();
            if (u != null) {
                R r;
                try {
                    r = this.combiner.apply(t, u);
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.dispose();
                    this.actual.onError(e);
                    return;
                }
                this.actual.onNext(r);
            }
        }

        @Override
        public void onError(Throwable t) {
            DisposableHelper.dispose(this.other);
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            DisposableHelper.dispose(this.other);
            this.actual.onComplete();
        }

        @Override
        public void dispose() {
            this.s.get().dispose();
            DisposableHelper.dispose(this.other);
        }

        @Override
        public boolean isDisposed() {
            return this.s.get().isDisposed();
        }

        public boolean setOther(Disposable o) {
            do {
                Disposable current;
                if ((current = this.other.get()) == DisposableHelper.DISPOSED) {
                    o.dispose();
                    return false;
                }
                if (current == null) continue;
                RxJavaPlugins.onError(new IllegalStateException("Other subscription already set!"));
                o.dispose();
                return false;
            } while (!this.other.compareAndSet(null, o));
            return true;
        }

        public void otherError(Throwable e) {
            if (this.s.compareAndSet(null, DisposableHelper.DISPOSED)) {
                EmptyDisposable.error(e, this.actual);
            } else if (this.s.get() != DisposableHelper.DISPOSED) {
                this.dispose();
                this.actual.onError(e);
            } else {
                RxJavaPlugins.onError(e);
            }
        }
    }
}

