/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public final class ObservableZip<T, R>
extends Observable<R> {
    final ObservableSource<? extends T>[] sources;
    final Iterable<? extends ObservableSource<? extends T>> sourcesIterable;
    final Function<? super Object[], ? extends R> zipper;
    final int bufferSize;
    final boolean delayError;

    public ObservableZip(ObservableSource<? extends T>[] sources, Iterable<? extends ObservableSource<? extends T>> sourcesIterable, Function<? super Object[], ? extends R> zipper, int bufferSize, boolean delayError) {
        this.sources = sources;
        this.sourcesIterable = sourcesIterable;
        this.zipper = zipper;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribeActual(Observer<? super R> s) {
        ObservableSource<? extends T>[] sources = this.sources;
        int count = 0;
        if (sources == null) {
            sources = new Observable[8];
            for (ObservableSource<? extends T> observableSource : this.sourcesIterable) {
                if (count == sources.length) {
                    ObservableSource[] b = new ObservableSource[count + (count >> 2)];
                    System.arraycopy(sources, 0, b, 0, count);
                    sources = b;
                }
                sources[count++] = observableSource;
            }
        } else {
            count = sources.length;
        }
        if (count == 0) {
            EmptyDisposable.complete(s);
            return;
        }
        ZipCoordinator<? extends T, R> zc = new ZipCoordinator<T, R>(s, this.zipper, count, this.delayError);
        zc.subscribe(sources, this.bufferSize);
    }

    static final class ZipObserver<T, R>
    implements Observer<T>,
    Disposable {
        final ZipCoordinator<T, R> parent;
        final SpscLinkedArrayQueue<T> queue;
        volatile boolean done;
        Throwable error;
        final AtomicReference<Disposable> s = new AtomicReference();

        ZipObserver(ZipCoordinator<T, R> parent, int bufferSize) {
            this.parent = parent;
            this.queue = new SpscLinkedArrayQueue(bufferSize);
        }

        @Override
        public void onSubscribe(Disposable s) {
            DisposableHelper.setOnce(this.s, s);
        }

        @Override
        public void onNext(T t) {
            if (t == null) {
                this.s.get().dispose();
                this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
                return;
            }
            if (!this.queue.offer(t)) {
                this.s.get().dispose();
                this.onError(new IllegalStateException("Queue full?!"));
                return;
            }
            this.parent.drain();
        }

        @Override
        public void onError(Throwable t) {
            this.error = t;
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.parent.drain();
        }

        @Override
        public void dispose() {
            DisposableHelper.dispose(this.s);
        }

        @Override
        public boolean isDisposed() {
            return this.s.get() == DisposableHelper.DISPOSED;
        }
    }

    static final class ZipCoordinator<T, R>
    extends AtomicInteger
    implements Disposable {
        private static final long serialVersionUID = 2983708048395377667L;
        final Observer<? super R> actual;
        final Function<? super Object[], ? extends R> zipper;
        final ZipObserver<T, R>[] observers;
        final T[] row;
        final boolean delayError;
        volatile boolean cancelled;

        ZipCoordinator(Observer<? super R> actual, Function<? super Object[], ? extends R> zipper, int count, boolean delayError) {
            this.actual = actual;
            this.zipper = zipper;
            this.observers = new ZipObserver[count];
            this.row = new Object[count];
            this.delayError = delayError;
        }

        public void subscribe(ObservableSource<? extends T>[] sources, int bufferSize) {
            int i;
            ZipObserver<T, R>[] s = this.observers;
            int len = s.length;
            for (i = 0; i < len; ++i) {
                s[i] = new ZipObserver(this, bufferSize);
            }
            this.lazySet(0);
            this.actual.onSubscribe(this);
            for (i = 0; i < len; ++i) {
                if (this.cancelled) {
                    return;
                }
                sources[i].subscribe(s[i]);
            }
        }

        @Override
        public void dispose() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (this.getAndIncrement() == 0) {
                    this.clear();
                }
            }
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        void clear() {
            for (ZipObserver<T, R> zs : this.observers) {
                zs.dispose();
                zs.queue.clear();
            }
        }

        public void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missing = 1;
            ZipObserver<T, R>[] zs = this.observers;
            Observer<R> a = this.actual;
            Object[] os = this.row;
            boolean delayError = this.delayError;
            while (true) {
                int i = 0;
                int emptyCount = 0;
                for (ZipObserver<T, R> z : zs) {
                    Throwable ex;
                    if (os[i] == null) {
                        boolean empty;
                        boolean d = z.done;
                        Object v = z.queue.poll();
                        boolean bl = empty = v == null;
                        if (this.checkTerminated(d, empty, a, delayError, z)) {
                            return;
                        }
                        if (!empty) {
                            os[i] = v;
                        } else {
                            ++emptyCount;
                        }
                    } else if (z.done && !delayError && (ex = z.error) != null) {
                        this.clear();
                        a.onError(ex);
                        return;
                    }
                    ++i;
                }
                if (emptyCount == 0) {
                    R v;
                    try {
                        v = this.zipper.apply((Object[])os.clone());
                    }
                    catch (Throwable ex) {
                        Exceptions.throwIfFatal(ex);
                        this.clear();
                        a.onError(ex);
                        return;
                    }
                    if (v == null) {
                        this.clear();
                        a.onError(new NullPointerException("The zipper returned a null value"));
                        return;
                    }
                    a.onNext(v);
                    Arrays.fill(os, null);
                    continue;
                }
                if ((missing = this.addAndGet(-missing)) == 0) break;
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Observer<? super R> a, boolean delayError, ZipObserver<?, ?> source) {
            if (this.cancelled) {
                this.clear();
                return true;
            }
            if (d) {
                if (delayError) {
                    if (empty) {
                        Throwable e = source.error;
                        this.clear();
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = source.error;
                    if (e != null) {
                        this.clear();
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        this.clear();
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

