/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.disposables.EmptyDisposable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Iterator;

public final class ObservableZipIterable<T, U, V>
extends Observable<V> {
    final Observable<? extends T> source;
    final Iterable<U> other;
    final BiFunction<? super T, ? super U, ? extends V> zipper;

    public ObservableZipIterable(Observable<? extends T> source, Iterable<U> other, BiFunction<? super T, ? super U, ? extends V> zipper) {
        this.source = source;
        this.other = other;
        this.zipper = zipper;
    }

    @Override
    public void subscribeActual(Observer<? super V> t) {
        boolean b;
        Iterator<U> it;
        try {
            it = this.other.iterator();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        if (it == null) {
            EmptyDisposable.error((Throwable)new NullPointerException("The iterator returned by other is null"), t);
            return;
        }
        try {
            b = it.hasNext();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            EmptyDisposable.error(e, t);
            return;
        }
        if (!b) {
            EmptyDisposable.complete(t);
            return;
        }
        this.source.subscribe(new ZipIterableObserver<T, U, V>(t, it, this.zipper));
    }

    static final class ZipIterableObserver<T, U, V>
    implements Observer<T>,
    Disposable {
        final Observer<? super V> actual;
        final Iterator<U> iterator;
        final BiFunction<? super T, ? super U, ? extends V> zipper;
        Disposable s;
        boolean done;

        ZipIterableObserver(Observer<? super V> actual, Iterator<U> iterator, BiFunction<? super T, ? super U, ? extends V> zipper) {
            this.actual = actual;
            this.iterator = iterator;
            this.zipper = zipper;
        }

        @Override
        public void onSubscribe(Disposable s) {
            if (DisposableHelper.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.s.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.s.isDisposed();
        }

        @Override
        public void onNext(T t) {
            boolean b;
            V v;
            U u;
            if (this.done) {
                return;
            }
            try {
                u = this.iterator.next();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            if (u == null) {
                this.error(new NullPointerException("The iterator returned a null value"));
                return;
            }
            try {
                v = this.zipper.apply(t, u);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(new NullPointerException("The iterator returned a null value"));
                return;
            }
            if (v == null) {
                this.error(new NullPointerException("The zipper function returned a null value"));
                return;
            }
            this.actual.onNext(v);
            try {
                b = this.iterator.hasNext();
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.error(e);
                return;
            }
            if (!b) {
                this.done = true;
                this.s.dispose();
                this.actual.onComplete();
            }
        }

        void error(Throwable e) {
            this.done = true;
            this.s.dispose();
            this.actual.onError(e);
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }
    }
}

