/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.SequentialDisposable;

public final class SingleResumeNext<T>
extends Single<T> {
    final SingleSource<? extends T> source;
    final Function<? super Throwable, ? extends SingleSource<? extends T>> nextFunction;

    public SingleResumeNext(SingleSource<? extends T> source, Function<? super Throwable, ? extends SingleSource<? extends T>> nextFunction) {
        this.source = source;
        this.nextFunction = nextFunction;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        final SequentialDisposable sd = new SequentialDisposable();
        s.onSubscribe(sd);
        this.source.subscribe(new SingleObserver<T>(){

            @Override
            public void onSubscribe(Disposable d) {
                sd.replace(d);
            }

            @Override
            public void onSuccess(T value) {
                s.onSuccess(value);
            }

            @Override
            public void onError(Throwable e) {
                SingleSource next;
                try {
                    next = SingleResumeNext.this.nextFunction.apply(e);
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    s.onError(new CompositeException(ex, e));
                    return;
                }
                if (next == null) {
                    NullPointerException npe = new NullPointerException("The next Single supplied was null");
                    npe.initCause(e);
                    s.onError(npe);
                    return;
                }
                next.subscribe(new SingleObserver<T>(){

                    @Override
                    public void onSubscribe(Disposable d) {
                        sd.replace(d);
                    }

                    @Override
                    public void onSuccess(T value) {
                        s.onSuccess(value);
                    }

                    @Override
                    public void onError(Throwable e) {
                        s.onError(e);
                    }
                });
            }
        });
    }
}

