/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.queue;

import io.reactivex.internal.fuseable.SimpleQueue;
import io.reactivex.internal.util.Pow2;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class SpscArrayQueue<E>
extends AtomicReferenceArray<E>
implements SimpleQueue<E> {
    private static final long serialVersionUID = -1296597691183856449L;
    private static final Integer MAX_LOOK_AHEAD_STEP = Integer.getInteger("jctools.spsc.max.lookahead.step", 4096);
    final int mask = this.length() - 1;
    final AtomicLong producerIndex = new AtomicLong();
    long producerLookAhead;
    final AtomicLong consumerIndex = new AtomicLong();
    final int lookAheadStep;

    public SpscArrayQueue(int capacity) {
        super(Pow2.roundToPowerOfTwo(capacity));
        this.lookAheadStep = Math.min(capacity / 4, MAX_LOOK_AHEAD_STEP);
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException("Null is not a valid element");
        }
        int mask = this.mask;
        long index = this.producerIndex.get();
        int offset = this.calcElementOffset(index, mask);
        if (index >= this.producerLookAhead) {
            int step = this.lookAheadStep;
            if (null == this.lvElement(this.calcElementOffset(index + (long)step, mask))) {
                this.producerLookAhead = index + (long)step;
            } else if (null != this.lvElement(offset)) {
                return false;
            }
        }
        this.soElement(offset, e);
        this.soProducerIndex(index + 1L);
        return true;
    }

    @Override
    public boolean offer(E v1, E v2) {
        return this.offer(v1) && this.offer(v2);
    }

    @Override
    public E poll() {
        long index = this.consumerIndex.get();
        int offset = this.calcElementOffset(index);
        E e = this.lvElement(offset);
        if (null == e) {
            return null;
        }
        this.soConsumerIndex(index + 1L);
        this.soElement(offset, null);
        return e;
    }

    @Override
    public boolean isEmpty() {
        return this.producerIndex.get() == this.consumerIndex.get();
    }

    void soProducerIndex(long newIndex) {
        this.producerIndex.lazySet(newIndex);
    }

    void soConsumerIndex(long newIndex) {
        this.consumerIndex.lazySet(newIndex);
    }

    @Override
    public void clear() {
        while (this.poll() != null || !this.isEmpty()) {
        }
    }

    int calcElementOffset(long index, int mask) {
        return (int)index & mask;
    }

    int calcElementOffset(long index) {
        return (int)index & this.mask;
    }

    void soElement(int offset, E value) {
        this.lazySet(offset, value);
    }

    E lvElement(int offset) {
        return this.get(offset);
    }
}

