/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.avro.mappers;

import io.simplesource.kafka.serialization.avro.AvroSpecificGenericMapper;
import io.simplesource.kafka.serialization.avro.mappers.DomainMapperRegistry;
import io.simplesource.kafka.serialization.avro.mappers.DomainSerializedClassMapperImpl;
import io.simplesource.kafka.serialization.avro.mappers.RegistryBasedDomainMapper;
import io.simplesource.kafka.serialization.avro.mappers.steps.DomainSerializedClassMapperToSerializedStep;
import io.simplesource.kafka.serialization.util.GenericMapper;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.avro.generic.GenericRecord;

public final class DomainMapperBuilder {
    private final DomainMapperRegistry domainMapperRegistry;
    private BuildConfig buildConfig;

    public DomainMapperBuilder() {
        this(new DomainMapperRegistry());
    }

    public DomainMapperBuilder(DomainMapperRegistry domainMapperRegistry) {
        this.domainMapperRegistry = domainMapperRegistry;
        this.buildConfig = new BuildConfig();
    }

    public <D, A extends GenericRecord> DomainSerializedClassMapperToSerializedStep<D, A> mapperFor(Class<D> domainClass, Class<A> serializedClass) {
        return new DomainSerializedClassMapperImpl(this, this.domainMapperRegistry).mapperFor(domainClass, serializedClass);
    }

    public <D, A extends GenericRecord> DomainSerializedClassMapperToSerializedStep<Optional<D>, A> optionalMapperFor(Class<D> domainClass, Class<A> serializedClass) {
        this.buildConfig.setDomainValueToClassFunc(v -> v.map(Object::getClass).orElse(domainClass));
        return new DomainSerializedClassMapperImpl(this, this.domainMapperRegistry).mapperFor(domainClass, serializedClass);
    }

    public DomainMapperBuilder withExceptionSupplierForNotRegisteredMapper(Supplier<RuntimeException> exceptionSupplier) {
        this.buildConfig.exceptionSupplier = Optional.of(Objects.requireNonNull(exceptionSupplier));
        return this;
    }

    public <D, A extends GenericRecord> GenericMapper<D, A> build() {
        return this.build(AvroSpecificGenericMapper.specificDomainMapper());
    }

    public <D, A extends GenericRecord> GenericMapper<D, A> build(GenericMapper<A, GenericRecord> avroSpecificGenericMapper) {
        RegistryBasedDomainMapper domainMapper = new RegistryBasedDomainMapper(this.domainMapperRegistry, avroSpecificGenericMapper, this.buildConfig.getDomainValueToClassFunc());
        this.buildConfig.exceptionSupplier.ifPresent(domainMapper::withExceptionSupplier);
        return domainMapper;
    }

    private class BuildConfig {
        Optional<Supplier<RuntimeException>> exceptionSupplier = Optional.empty();
        private Function<?, Class<?>> domainValueToClassFunc = Object::getClass;

        private BuildConfig() {
        }

        <D> Function<D, Class<?>> getDomainValueToClassFunc() {
            return this.domainValueToClassFunc;
        }

        <D> void setDomainValueToClassFunc(Function<D, Class<?>> domainValueToClassFunc) {
            this.domainValueToClassFunc = domainValueToClassFunc;
        }
    }
}

