/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import io.simplesource.api.CommandAPI;
import io.simplesource.data.NonEmptyList;
import io.simplesource.data.Reason;
import io.simplesource.data.Result;
import io.simplesource.data.Sequence;
import io.simplesource.kafka.api.AggregateSerdes;
import io.simplesource.kafka.model.AggregateUpdate;
import io.simplesource.kafka.model.AggregateUpdateResult;
import io.simplesource.kafka.model.CommandRequest;
import io.simplesource.kafka.model.ValueWithSequence;
import io.simplesource.kafka.serialization.json.JsonGenericMapper;
import io.simplesource.kafka.serialization.util.GenericMapper;
import io.simplesource.kafka.serialization.util.GenericSerde;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.connect.json.JsonSerializer;
import org.apache.kafka.streams.kstream.Consumed;
import org.apache.kafka.streams.kstream.Produced;
import org.apache.kafka.streams.kstream.Serialized;

public final class JsonAggregateSerdes<K, C, E, A>
implements AggregateSerdes<K, C, E, A> {
    private final GenericMapper<A, JsonElement> aggregateMapper;
    private final GenericMapper<E, JsonElement> eventMapper;
    private final GenericMapper<C, JsonElement> commandMapper;
    private final GenericMapper<K, JsonElement> keyMapper;
    private final Serde<String> serde;
    private final Consumed<String, String> consumed;
    private final Produced<String, String> produced;
    private final Serialized<String, String> serialized;
    private final Map<String, Object> serializerConfig;
    private final Gson gson;
    private final JsonParser parser;
    private final Serde<K> ak;
    private final Serde<CommandRequest<C>> cr;
    private final Serde<UUID> crk;
    private final Serde<ValueWithSequence<E>> vws;
    private final Serde<AggregateUpdate<A>> au;
    private final Serde<AggregateUpdateResult<A>> aur;

    public JsonAggregateSerdes() {
        this(JsonGenericMapper.jsonDomainMapper(), JsonGenericMapper.jsonDomainMapper(), JsonGenericMapper.jsonDomainMapper(), JsonGenericMapper.jsonDomainMapper());
    }

    public JsonAggregateSerdes(GenericMapper<A, JsonElement> aggregateMapper, GenericMapper<E, JsonElement> eventMapper, GenericMapper<C, JsonElement> commandMapper, GenericMapper<K, JsonElement> keyMapper) {
        this.aggregateMapper = aggregateMapper;
        this.eventMapper = eventMapper;
        this.commandMapper = commandMapper;
        this.keyMapper = keyMapper;
        this.serde = Serdes.String();
        this.consumed = Consumed.with(this.serde, this.serde);
        this.produced = Produced.with(this.serde, this.serde);
        this.serialized = Serialized.with(this.serde, this.serde);
        HashMap<String, Class<JsonSerializer>> configs = new HashMap<String, Class<JsonSerializer>>();
        configs.put("key.serializer", JsonSerializer.class);
        configs.put("value.serializer", JsonSerializer.class);
        this.serializerConfig = Collections.unmodifiableMap(configs);
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(CommandRequest.class, (Object)new CommandRequestAdapter());
        gsonBuilder.registerTypeAdapter(UUID.class, (Object)new UUIDAdapter());
        gsonBuilder.registerTypeAdapter(ValueWithSequence.class, (Object)new ValueWithSequenceAdapter());
        gsonBuilder.registerTypeAdapter(AggregateUpdate.class, (Object)new AggregateUpdateAdapter());
        gsonBuilder.registerTypeAdapter(AggregateUpdateResult.class, (Object)new AggregateUpdateResultAdapter());
        this.gson = gsonBuilder.create();
        this.parser = new JsonParser();
        this.ak = GenericSerde.of(this.serde, k -> ((JsonElement)keyMapper.toGeneric(k)).toString(), s -> keyMapper.fromGeneric(this.parser.parse(s)));
        this.cr = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (CommandRequest)this.gson.fromJson(s, new TypeToken<CommandRequest<C>>(){}.getType()));
        this.crk = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (UUID)this.gson.fromJson(s, new TypeToken<UUID>(){}.getType()));
        this.vws = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (ValueWithSequence)this.gson.fromJson(s, new TypeToken<ValueWithSequence<E>>(){}.getType()));
        this.au = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (AggregateUpdate)this.gson.fromJson(s, new TypeToken<AggregateUpdate<A>>(){}.getType()));
        this.aur = GenericSerde.of(this.serde, arg_0 -> ((Gson)this.gson).toJson(arg_0), s -> (AggregateUpdateResult)this.gson.fromJson(s, new TypeToken<AggregateUpdateResult<A>>(){}.getType()));
    }

    public Serde<K> aggregateKey() {
        return this.ak;
    }

    public Serde<CommandRequest<C>> commandRequest() {
        return this.cr;
    }

    public Serde<UUID> commandResponseKey() {
        return this.crk;
    }

    public Serde<ValueWithSequence<E>> valueWithSequence() {
        return this.vws;
    }

    public Serde<AggregateUpdate<A>> aggregateUpdate() {
        return this.au;
    }

    public Serde<AggregateUpdateResult<A>> updateResult() {
        return this.aur;
    }

    public Map<String, Object> serializerConfig() {
        return this.serializerConfig;
    }

    private class AggregateUpdateResultAdapter
    implements com.google.gson.JsonSerializer<AggregateUpdateResult<A>>,
    JsonDeserializer<AggregateUpdateResult<A>> {
        private static final String READ_SEQUENCE = "readSequence";
        private static final String COMMAND_ID = "commandId";
        private static final String RESULT = "result";
        private static final String REASON = "reason";
        private static final String ADDITIONAL_REASONS = "additionalReasons";
        private static final String ERROR_MESSAGE = "errorMessage";
        private static final String ERROR_CODE = "errorCode";
        private static final String WRITE_SEQUENCE = "writeSequence";
        private static final String AGGREGATION = "aggregate_update";

        private AggregateUpdateResultAdapter() {
        }

        public JsonElement serialize(AggregateUpdateResult<A> aggregateUpdateResult, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty(READ_SEQUENCE, (Number)aggregateUpdateResult.readSequence().getSeq());
            wrapper.addProperty(COMMAND_ID, aggregateUpdateResult.commandId().toString());
            wrapper.add(RESULT, (JsonElement)aggregateUpdateResult.updatedAggregateResult().fold(reasons -> {
                JsonObject failureWrapper = new JsonObject();
                failureWrapper.add(REASON, this.serializeReason((Reason<CommandAPI.CommandError>)((Reason)reasons.head())));
                JsonArray additionalReasons = new JsonArray();
                reasons.tail().forEach(reason -> additionalReasons.add(this.serializeReason((Reason<CommandAPI.CommandError>)reason)));
                failureWrapper.add(ADDITIONAL_REASONS, (JsonElement)additionalReasons);
                return failureWrapper;
            }, aggregateUpdate -> {
                JsonObject successWrapper = new JsonObject();
                successWrapper.addProperty(WRITE_SEQUENCE, (Number)aggregateUpdate.sequence().getSeq());
                successWrapper.add(AGGREGATION, (JsonElement)JsonAggregateSerdes.this.aggregateMapper.toGeneric(aggregateUpdate.aggregate()));
                return successWrapper;
            }));
            return wrapper;
        }

        private JsonElement serializeReason(Reason<CommandAPI.CommandError> reason) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty(ERROR_MESSAGE, reason.getMessage());
            wrapper.addProperty(ERROR_CODE, ((CommandAPI.CommandError)reason.getError()).name());
            return wrapper;
        }

        public AggregateUpdateResult<A> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            Result result;
            JsonObject wrapper = jsonElement.getAsJsonObject();
            Sequence readSequence = Sequence.position((long)wrapper.getAsJsonPrimitive(READ_SEQUENCE).getAsLong());
            UUID commandId = UUID.fromString(wrapper.getAsJsonPrimitive(COMMAND_ID).getAsString());
            JsonObject resultWrapper = wrapper.getAsJsonObject(RESULT);
            if (resultWrapper.has(REASON)) {
                Reason<CommandAPI.CommandError> headReason = this.deserializeReason(resultWrapper.getAsJsonObject(REASON));
                ArrayList tailReasons = new ArrayList();
                resultWrapper.getAsJsonArray(ADDITIONAL_REASONS).forEach(reason -> tailReasons.add(this.deserializeReason(reason.getAsJsonObject())));
                result = Result.failure((NonEmptyList)new NonEmptyList(headReason, tailReasons));
            } else {
                result = Result.success((Object)new AggregateUpdate(JsonAggregateSerdes.this.aggregateMapper.fromGeneric(resultWrapper.getAsJsonObject(AGGREGATION)), Sequence.position((long)resultWrapper.getAsJsonPrimitive(WRITE_SEQUENCE).getAsLong())));
            }
            return new AggregateUpdateResult(commandId, readSequence, result);
        }

        private Reason<CommandAPI.CommandError> deserializeReason(JsonObject element) {
            return Reason.of((Object)CommandAPI.CommandError.valueOf((String)element.getAsJsonPrimitive(ERROR_CODE).getAsString()), (String)element.getAsJsonPrimitive(ERROR_MESSAGE).getAsString());
        }
    }

    private class AggregateUpdateAdapter
    implements com.google.gson.JsonSerializer<AggregateUpdate<A>>,
    JsonDeserializer<AggregateUpdate<A>> {
        private static final String AGGREGATION = "aggregate_update";
        private static final String SEQUENCE = "sequence";

        private AggregateUpdateAdapter() {
        }

        public JsonElement serialize(AggregateUpdate<A> aggregateUpdate, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.add(AGGREGATION, (JsonElement)JsonAggregateSerdes.this.aggregateMapper.toGeneric(aggregateUpdate.aggregate()));
            wrapper.addProperty(SEQUENCE, (Number)aggregateUpdate.sequence().getSeq());
            return wrapper;
        }

        public AggregateUpdate<A> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject wrapper = jsonElement.getAsJsonObject();
            return new AggregateUpdate(JsonAggregateSerdes.this.aggregateMapper.fromGeneric(wrapper.get(AGGREGATION)), Sequence.position((long)wrapper.getAsJsonPrimitive(SEQUENCE).getAsLong()));
        }
    }

    private class ValueWithSequenceAdapter
    implements com.google.gson.JsonSerializer<ValueWithSequence<E>>,
    JsonDeserializer<ValueWithSequence<E>> {
        private static final String VALUE = "value";
        private static final String SEQUENCE = "sequence";

        private ValueWithSequenceAdapter() {
        }

        public JsonElement serialize(ValueWithSequence<E> valueWithSequence, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.add(VALUE, (JsonElement)JsonAggregateSerdes.this.eventMapper.toGeneric(valueWithSequence.value()));
            wrapper.addProperty(SEQUENCE, (Number)valueWithSequence.sequence().getSeq());
            return wrapper;
        }

        public ValueWithSequence<E> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject wrapper = jsonElement.getAsJsonObject();
            return new ValueWithSequence(JsonAggregateSerdes.this.eventMapper.fromGeneric(wrapper.get(VALUE)), Sequence.position((long)wrapper.getAsJsonPrimitive(SEQUENCE).getAsLong()));
        }
    }

    private class UUIDAdapter
    implements com.google.gson.JsonSerializer<UUID>,
    JsonDeserializer<UUID> {
        private static final String COMMAND_ID = "commandId";

        private UUIDAdapter() {
        }

        public JsonElement serialize(UUID uuid, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty(COMMAND_ID, uuid.toString());
            return wrapper;
        }

        public UUID deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject wrapper = jsonElement.getAsJsonObject();
            return UUID.fromString(wrapper.getAsJsonPrimitive(COMMAND_ID).getAsString());
        }
    }

    private class CommandRequestAdapter
    implements com.google.gson.JsonSerializer<CommandRequest<C>>,
    JsonDeserializer<CommandRequest<C>> {
        private static final String READ_SEQUENCE = "readSequence";
        private static final String COMMAND_ID = "commandId";
        private static final String COMMAND = "command";

        private CommandRequestAdapter() {
        }

        public JsonElement serialize(CommandRequest<C> commandRequest, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject wrapper = new JsonObject();
            wrapper.addProperty(READ_SEQUENCE, (Number)commandRequest.readSequence().getSeq());
            wrapper.addProperty(COMMAND_ID, commandRequest.commandId().toString());
            wrapper.add(COMMAND, (JsonElement)JsonAggregateSerdes.this.commandMapper.toGeneric(commandRequest.command()));
            return wrapper;
        }

        public CommandRequest<C> deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject wrapper = jsonElement.getAsJsonObject();
            return new CommandRequest(JsonAggregateSerdes.this.commandMapper.fromGeneric(wrapper.get(COMMAND)), Sequence.position((long)wrapper.getAsJsonPrimitive(READ_SEQUENCE).getAsLong()), UUID.fromString(wrapper.getAsJsonPrimitive(COMMAND_ID).getAsString()));
        }
    }
}

