/*
 * Decompiled with CFR 0.152.
 */
package io.simplesource.kafka.serialization.avro;

import io.simplesource.api.CommandError;
import io.simplesource.data.NonEmptyList;
import io.simplesource.data.Result;
import io.simplesource.data.Sequence;
import io.simplesource.kafka.model.AggregateUpdate;
import io.simplesource.kafka.model.AggregateUpdateResult;
import io.simplesource.kafka.model.CommandRequest;
import io.simplesource.kafka.model.CommandResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;

public final class AvroSerdes {
    private static Schema toNullableSchema(Schema schema) {
        return Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), schema));
    }

    static class AggregateUpdateAvroHelper {
        private static final Map<Schema, Schema> schemaCache = new ConcurrentHashMap<Schema, Schema>();
        private static final String AGGREGATION = "aggregate_update";
        private static final String SEQUENCE = "sequence";

        AggregateUpdateAvroHelper() {
        }

        static GenericRecord toGenericRecord(AggregateUpdate<GenericRecord> aggregateUpdate, Schema aggregateSchema) {
            Schema schema = schemaCache.computeIfAbsent(aggregateSchema, AggregateUpdateAvroHelper::generateSchema);
            GenericRecordBuilder builder = new GenericRecordBuilder(schema);
            return builder.set(AGGREGATION, aggregateUpdate.aggregate()).set(SEQUENCE, (Object)aggregateUpdate.sequence().getSeq()).build();
        }

        static AggregateUpdate<GenericRecord> fromGenericRecord(GenericRecord record) {
            GenericRecord genericAggregate = (GenericRecord)record.get(AGGREGATION);
            Sequence sequence = Sequence.position((long)((Long)record.get(SEQUENCE)));
            return new AggregateUpdate((Object)genericAggregate, sequence);
        }

        private static Schema generateSchema(Schema aggregateSchema) {
            return (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)(aggregateSchema.getName() + "OptionalAggregateWithSequence")).namespace(aggregateSchema.getNamespace())).fields().name(AGGREGATION).type(AvroSerdes.toNullableSchema(aggregateSchema)).withDefault(null).name(SEQUENCE).type().longType().noDefault().endRecord();
        }
    }

    static class CommandResponseAvroHelper {
        private static final Map<Schema, Schema> schemaCache = new ConcurrentHashMap<Schema, Schema>();
        private static final String READ_SEQUENCE = "readSequence";
        private static final String COMMAND_ID = "commandId";
        private static final String RESULT = "result";
        private static final String REASON = "reason";
        private static final String ADDITIONAL_REASONS = "additionalReasons";
        private static final String ERROR_MESSAGE = "errorMessage";
        private static final String ERROR_CODE = "errorCode";
        private static final String WRITE_SEQUENCE = "writeSequence";

        CommandResponseAvroHelper() {
        }

        static GenericRecord toCommandResponse(CommandResponse commandResponse) {
            Schema schema = CommandResponseAvroHelper.commandResponseSchema();
            Schema resultSchema = schema.getField(RESULT).schema();
            Schema responseFailureSchema = (Schema)resultSchema.getTypes().get(0);
            Schema reasonSchema = responseFailureSchema.getField(REASON).schema();
            Schema responseSuccessSchema = (Schema)resultSchema.getTypes().get(1);
            return new GenericRecordBuilder(schema).set(READ_SEQUENCE, (Object)commandResponse.readSequence().getSeq()).set(COMMAND_ID, (Object)commandResponse.commandId().toString()).set(RESULT, commandResponse.sequenceResult().fold(reasons -> new GenericRecordBuilder(responseFailureSchema).set(REASON, (Object)CommandResponseAvroHelper.fromReason(reasonSchema, (CommandError)reasons.head())).set(ADDITIONAL_REASONS, reasons.tail().stream().map(reason -> CommandResponseAvroHelper.fromReason(reasonSchema, reason)).collect(Collectors.toList())).build(), sequence -> new GenericRecordBuilder(responseSuccessSchema).set(WRITE_SEQUENCE, (Object)sequence.getSeq()).build())).build();
        }

        private static GenericRecord fromReason(Schema schema, CommandError commandError) {
            return new GenericRecordBuilder(schema).set(ERROR_MESSAGE, (Object)commandError.getMessage()).set(ERROR_CODE, (Object)commandError.getReason().name()).build();
        }

        static CommandResponse fromCommandResponse(GenericRecord record) {
            Result result;
            Sequence readSequence = Sequence.position((long)((Long)record.get(READ_SEQUENCE)));
            UUID commandId = UUID.fromString(String.valueOf(record.get(COMMAND_ID)));
            GenericRecord genericResult = (GenericRecord)record.get(RESULT);
            if (Objects.nonNull(genericResult.get(WRITE_SEQUENCE))) {
                Sequence writeSequence = Sequence.position((long)((Long)genericResult.get(WRITE_SEQUENCE)));
                result = Result.success((Object)writeSequence);
            } else {
                CommandError commandError = CommandResponseAvroHelper.toCommandError((GenericRecord)genericResult.get(REASON));
                List additionalCommandErrors = ((List)genericResult.get(ADDITIONAL_REASONS)).stream().map(x$0 -> AggregateUpdateResultAvroHelper.toCommandError(x$0)).collect(Collectors.toList());
                result = Result.failure((NonEmptyList)new NonEmptyList((Object)commandError, additionalCommandErrors));
            }
            return new CommandResponse(commandId, readSequence, result);
        }

        private static CommandError toCommandError(GenericRecord record) {
            CommandError.Reason error;
            String errorMessage = String.valueOf(record.get(ERROR_MESSAGE));
            String errorCodeStr = String.valueOf(record.get(ERROR_CODE));
            try {
                error = CommandError.Reason.valueOf((String)errorCodeStr);
            }
            catch (IllegalArgumentException e) {
                error = CommandError.Reason.UnexpectedErrorCode;
                errorMessage = errorMessage + "Unexpected errorCode " + errorCodeStr;
            }
            return CommandError.of((CommandError.Reason)error, (String)errorMessage);
        }

        private static Schema commandResponseSchema() {
            Schema reasonSchema = (Schema)SchemaBuilder.record((String)"Reason").fields().name(ERROR_MESSAGE).type().stringType().noDefault().name(ERROR_CODE).type().stringType().noDefault().endRecord();
            Schema updateFailure = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"CommandResponseFailure").fields().name(REASON).type(reasonSchema).noDefault().name(ADDITIONAL_REASONS).type().array().items(reasonSchema)).noDefault().endRecord();
            Schema updateSuccess = (Schema)SchemaBuilder.record((String)"CommandResponseSuccess").fields().name(WRITE_SEQUENCE).type().longType().noDefault().endRecord();
            return (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"CommandResponse").namespace("io.simplesource.kafka.serialization.avro")).fields().name(READ_SEQUENCE).type().longType().noDefault().name(COMMAND_ID).type().stringType().noDefault().name(RESULT).type(Schema.createUnion(Arrays.asList(updateFailure, updateSuccess))).noDefault().endRecord();
        }
    }

    static class AggregateUpdateResultAvroHelper {
        private static final Map<Schema, Schema> schemaCache = new ConcurrentHashMap<Schema, Schema>();
        private static final String READ_SEQUENCE = "readSequence";
        private static final String COMMAND_ID = "commandId";
        private static final String RESULT = "result";
        private static final String REASON = "reason";
        private static final String ADDITIONAL_REASONS = "additionalReasons";
        private static final String ERROR_MESSAGE = "errorMessage";
        private static final String ERROR_CODE = "errorCode";
        private static final String WRITE_SEQUENCE = "writeSequence";
        private static final String AGGREGATION = "aggregate_update";

        AggregateUpdateResultAvroHelper() {
        }

        static GenericRecord toAggregateUpdateResult(AggregateUpdateResult<GenericRecord> aggregateUpdateResult, Schema aggregateSchema) {
            Schema schema = schemaCache.computeIfAbsent(aggregateSchema, AggregateUpdateResultAvroHelper::aggregateUpdateResultSchema);
            Schema resultSchema = schema.getField(RESULT).schema();
            Schema responseFailureSchema = (Schema)resultSchema.getTypes().get(0);
            Schema reasonSchema = responseFailureSchema.getField(REASON).schema();
            Schema responseSuccessSchema = (Schema)resultSchema.getTypes().get(1);
            return new GenericRecordBuilder(schema).set(READ_SEQUENCE, (Object)aggregateUpdateResult.readSequence().getSeq()).set(COMMAND_ID, (Object)aggregateUpdateResult.commandId().toString()).set(RESULT, aggregateUpdateResult.updatedAggregateResult().fold(reasons -> new GenericRecordBuilder(responseFailureSchema).set(REASON, (Object)AggregateUpdateResultAvroHelper.fromReason(reasonSchema, (CommandError)reasons.head())).set(ADDITIONAL_REASONS, reasons.tail().stream().map(reason -> AggregateUpdateResultAvroHelper.fromReason(reasonSchema, reason)).collect(Collectors.toList())).build(), aggregateUpdate -> new GenericRecordBuilder(responseSuccessSchema).set(WRITE_SEQUENCE, (Object)aggregateUpdate.sequence().getSeq()).set(AGGREGATION, aggregateUpdate.aggregate()).build())).build();
        }

        private static GenericRecord fromReason(Schema schema, CommandError commandError) {
            return new GenericRecordBuilder(schema).set(ERROR_MESSAGE, (Object)commandError.getMessage()).set(ERROR_CODE, (Object)commandError.getReason().name()).build();
        }

        static AggregateUpdateResult<GenericRecord> fromAggregateUpdateResult(GenericRecord record) {
            Result result;
            Sequence readSequence = Sequence.position((long)((Long)record.get(READ_SEQUENCE)));
            UUID commandId = UUID.fromString(String.valueOf(record.get(COMMAND_ID)));
            GenericRecord genericResult = (GenericRecord)record.get(RESULT);
            if (Objects.nonNull(genericResult.get(WRITE_SEQUENCE))) {
                Sequence writeSequence = Sequence.position((long)((Long)genericResult.get(WRITE_SEQUENCE)));
                GenericRecord genericAggregate = (GenericRecord)genericResult.get(AGGREGATION);
                result = Result.success((Object)new AggregateUpdate((Object)genericAggregate, writeSequence));
            } else {
                CommandError commandError = AggregateUpdateResultAvroHelper.toCommandError((GenericRecord)genericResult.get(REASON));
                List additionalCommandErrors = ((List)genericResult.get(ADDITIONAL_REASONS)).stream().map(AggregateUpdateResultAvroHelper::toCommandError).collect(Collectors.toList());
                result = Result.failure((NonEmptyList)new NonEmptyList((Object)commandError, additionalCommandErrors));
            }
            return new AggregateUpdateResult(commandId, readSequence, result);
        }

        private static CommandError toCommandError(GenericRecord record) {
            CommandError.Reason error;
            String errorMessage = String.valueOf(record.get(ERROR_MESSAGE));
            String errorCodeStr = String.valueOf(record.get(ERROR_CODE));
            try {
                error = CommandError.Reason.valueOf((String)errorCodeStr);
            }
            catch (IllegalArgumentException e) {
                error = CommandError.Reason.UnexpectedErrorCode;
                errorMessage = errorMessage + "Unexpected errorCode " + errorCodeStr;
            }
            return CommandError.of((CommandError.Reason)error, (String)errorMessage);
        }

        private static Schema aggregateUpdateResultSchema(Schema aggregateSchema) {
            Schema reasonSchema = (Schema)SchemaBuilder.record((String)(aggregateSchema.getName() + "Reason")).fields().name(ERROR_MESSAGE).type().stringType().noDefault().name(ERROR_CODE).type().stringType().noDefault().endRecord();
            Schema updateFailure = (Schema)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)(aggregateSchema.getName() + "CommandResponseFailure")).fields().name(REASON).type(reasonSchema).noDefault().name(ADDITIONAL_REASONS).type().array().items(reasonSchema)).noDefault().endRecord();
            Schema updateSuccess = (Schema)SchemaBuilder.record((String)(aggregateSchema.getName() + "CommandResponseSuccess")).fields().name(WRITE_SEQUENCE).type().longType().noDefault().name(AGGREGATION).type(AvroSerdes.toNullableSchema(aggregateSchema)).withDefault(null).endRecord();
            return (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)(aggregateSchema.getName() + "CommandResponse")).namespace(aggregateSchema.getNamespace())).fields().name(READ_SEQUENCE).type().longType().noDefault().name(COMMAND_ID).type().stringType().noDefault().name(RESULT).type(Schema.createUnion(Arrays.asList(updateFailure, updateSuccess))).noDefault().endRecord();
        }
    }

    static class CommandResponseKeyAvroHelper {
        private static final Schema schema = CommandResponseKeyAvroHelper.commandResponseKeySchema();
        private static final String COMMAND_ID = "commandId";

        CommandResponseKeyAvroHelper() {
        }

        static GenericRecord toGenericRecord(UUID commandResponseKey) {
            GenericRecordBuilder builder = new GenericRecordBuilder(schema);
            return builder.set(COMMAND_ID, (Object)commandResponseKey.toString()).build();
        }

        static UUID fromGenericRecord(GenericRecord record) {
            return UUID.fromString(String.valueOf(record.get(COMMAND_ID)));
        }

        private static Schema commandResponseKeySchema() {
            return (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"CommandResponseKey").namespace("io.simplesource.kafka.serialization.avro")).fields().name(COMMAND_ID).type().stringType().noDefault().endRecord();
        }
    }

    static class CommandRequestAvroHelper {
        private static final Map<Schema, Schema> schemaCache = new ConcurrentHashMap<Schema, Schema>();
        private static final String AGGREGATE_KEY = "key";
        private static final String READ_SEQUENCE = "readSequence";
        private static final String COMMAND_ID = "commandId";
        private static final String COMMAND = "command";

        CommandRequestAvroHelper() {
        }

        static GenericRecord toGenericRecord(CommandRequest<GenericRecord, GenericRecord> commandRequest) {
            GenericRecord command = (GenericRecord)commandRequest.command();
            GenericRecord key = (GenericRecord)commandRequest.aggregateKey();
            Schema schema = schemaCache.computeIfAbsent(command.getSchema(), k -> CommandRequestAvroHelper.commandRequestSchema(command, key));
            GenericRecordBuilder builder = new GenericRecordBuilder(schema);
            return builder.set(AGGREGATE_KEY, commandRequest.aggregateKey()).set(READ_SEQUENCE, (Object)commandRequest.readSequence().getSeq()).set(COMMAND_ID, (Object)commandRequest.commandId().toString()).set(COMMAND, (Object)command).build();
        }

        static CommandRequest<GenericRecord, GenericRecord> fromGenericRecord(GenericRecord record) {
            GenericRecord aggregateKey = (GenericRecord)record.get(AGGREGATE_KEY);
            Sequence readSequence = Sequence.position((long)((Long)record.get(READ_SEQUENCE)));
            UUID commandId = UUID.fromString(String.valueOf(record.get(COMMAND_ID)));
            GenericRecord command = (GenericRecord)record.get(COMMAND);
            return new CommandRequest((Object)aggregateKey, (Object)command, readSequence, commandId);
        }

        private static Schema commandRequestSchema(GenericRecord command, GenericRecord key) {
            return (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)(command.getSchema().getName() + "CommandRequest")).namespace(command.getClass().getPackage().getName())).fields().name(AGGREGATE_KEY).type(key.getSchema()).noDefault().name(READ_SEQUENCE).type().longType().noDefault().name(COMMAND_ID).type().stringType().noDefault().name(COMMAND).type(command.getSchema()).noDefault().endRecord();
        }
    }
}

